/*
 * Decompiled with CFR 0.152.
 */
package cn.caict.encryption.common;

import cn.caict.encryption.model.KeyType;
import cn.caict.encryption.utils.hash.SM3Digest;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class CheckKey {
    public static boolean CheckSum(KeyType type, byte[] key) {
        return CheckKey.checkKey(type, key);
    }

    public static byte[] CalHash(KeyType type, byte[] data) {
        byte[] result = null;
        if (type == KeyType.ED25519) {
            MessageDigest sha256 = null;
            try {
                sha256 = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            sha256.update(data);
            result = sha256.digest();
        } else {
            result = SM3Digest.Hash(data);
        }
        return result;
    }

    private static boolean checkKey(KeyType type, byte[] key) {
        boolean SumIsRight = true;
        byte[] checkSrc = new byte[key.length - 4];
        byte[] checkSum = new byte[4];
        System.arraycopy(key, 0, checkSrc, 0, checkSrc.length);
        System.arraycopy(key, checkSrc.length, checkSum, 0, 4);
        byte[] hash1 = CheckKey.CalHash(type, checkSrc);
        byte[] hash2 = CheckKey.CalHash(type, hash1);
        byte[] HashSum = new byte[4];
        System.arraycopy(hash2, 0, HashSum, 0, 4);
        if (!Arrays.equals(HashSum, checkSum)) {
            SumIsRight = false;
        }
        return SumIsRight;
    }
}

