/*
 * Decompiled with CFR 0.152.
 */
package cn.caict.encryption.claim;

import cn.caict.encryption.key.PrivateKey;
import cn.caict.encryption.key.PublicKey;
import cn.caict.encryption.utils.hex.HexFormat;
import com.google.gson.annotations.SerializedName;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Claim {
    private String id;
    private String issuer;
    private String issuerName;
    private String issuanceDate;
    private String expirationDate;
    private CredentialSubjectBean credentialSubject;
    private RevocationBean revocation;
    @SerializedName(value="@context")
    private List<String> _$Context66;
    private List<String> type;
    private List<ProofBean> proof;

    public static boolean VerifyClaim(Claim claim) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Date format = dateFormat.parse(claim.getExpirationDate());
        if (System.currentTimeMillis() > format.getTime()) {
            return false;
        }
        for (ProofBean proof : claim.getProof()) {
            String type = "";
            int size = claim.getType().size();
            for (int i = 0; i < size; ++i) {
                type = type + claim.getType().get(i);
            }
            String msg = claim.get_$Context66() + claim.getId() + size + claim.getIssuer() + claim.getIssuerName() + claim.getIssuanceDate() + claim.getExpirationDate() + claim.getCredentialSubject().getId() + claim.getCredentialSubject().getName() + claim.getRevocation().getId();
            boolean flag = PublicKey.verify(msg.getBytes(), HexFormat.hexToByte(proof.getSignatureValue()), proof.get_$Pubkey58());
            if (flag) continue;
            return false;
        }
        return true;
    }

    public static Claim SignClaim(Claim claim, String skey) {
        String type = "";
        int size = claim.getType().size();
        for (int i = 0; i < size; ++i) {
            type = type + claim.getType().get(i);
        }
        String msg = claim.get_$Context66() + claim.getId() + size + claim.getIssuer() + claim.getIssuerName() + claim.getIssuanceDate() + claim.getExpirationDate() + claim.getCredentialSubject().getId() + claim.getCredentialSubject().getName() + claim.getRevocation().getId();
        PrivateKey key = new PrivateKey(skey);
        ProofBean proof = new ProofBean();
        proof.setCreator(claim.getIssuer());
        proof.setType("edd25519");
        proof.set_$Pubkey58(key.getEncPublicKey());
        proof.setSignatureValue(HexFormat.byteToHex(key.sign(msg.getBytes())));
        ArrayList<ProofBean> list = new ArrayList<ProofBean>();
        list.add(proof);
        claim.setProof(list);
        return claim;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
    }

    public String getIssuanceDate() {
        return this.issuanceDate;
    }

    public void setIssuanceDate(String issuanceDate) {
        this.issuanceDate = issuanceDate;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public CredentialSubjectBean getCredentialSubject() {
        return this.credentialSubject;
    }

    public void setCredentialSubject(CredentialSubjectBean credentialSubject) {
        this.credentialSubject = credentialSubject;
    }

    public RevocationBean getRevocation() {
        return this.revocation;
    }

    public void setRevocation(RevocationBean revocation) {
        this.revocation = revocation;
    }

    public List<String> get_$Context66() {
        return this._$Context66;
    }

    public void set_$Context66(List<String> _$Context66) {
        this._$Context66 = _$Context66;
    }

    public List<String> getType() {
        return this.type;
    }

    public void setType(List<String> type) {
        this.type = type;
    }

    public List<ProofBean> getProof() {
        return this.proof;
    }

    public void setProof(List<ProofBean> proof) {
        this.proof = proof;
    }

    public static class ProofBean {
        private String creator;
        private String type;
        @SerializedName(value="\u201cpubkey\u201d")
        private String _$Pubkey58;
        private String signatureValue;

        public String getCreator() {
            return this.creator;
        }

        public void setCreator(String creator) {
            this.creator = creator;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String get_$Pubkey58() {
            return this._$Pubkey58;
        }

        public void set_$Pubkey58(String _$Pubkey58) {
            this._$Pubkey58 = _$Pubkey58;
        }

        public String getSignatureValue() {
            return this.signatureValue;
        }

        public void setSignatureValue(String signatureValue) {
            this.signatureValue = signatureValue;
        }
    }

    public static class RevocationBean {
        private String id;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class CredentialSubjectBean {
        private String id;
        private String name;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

