package cn.caict.encryption.claim;

import cn.caict.encryption.key.PrivateKey;
import cn.caict.encryption.key.PublicKey;
import cn.caict.encryption.utils.hex.HexFormat;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class Claim {

    public static  boolean VerifyClaim(Claim claim) throws ParseException {
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Date format = dateFormat.parse(claim.getExpirationDate());
        if (System.currentTimeMillis() > format.getTime()){
            return false;
        }

        Iterator iter = claim.getProof().iterator();
        while(iter.hasNext()){
            ProofBean proof = (ProofBean) iter.next();
            String type ="";
            int size = claim.getType().size();
            for (int i=0;i<size;i++){
                type=type+ claim.getType().get(i);
            }
            String msg = claim.get_$Context66()+claim.getId()+size+claim.getIssuer()+claim.getIssuerName()
                    +claim.getIssuanceDate()+claim.getExpirationDate()+claim.getCredentialSubject().getId()+
                    claim.getCredentialSubject().getName()+claim.getRevocation().getId();
            boolean flag = PublicKey.verify(msg.getBytes(), HexFormat.hexToByte(proof.getSignatureValue()),proof.get_$Pubkey58());
            if(!flag){
                return false;
            }
        }
        return  true;
    }

    public static Claim SignClaim(Claim claim,String skey){
        String type ="";
        int size = claim.getType().size();
        for (int i=0;i<size;i++){
            type=type+ claim.getType().get(i);
        }

        String msg = claim.get_$Context66()+claim.getId()+size+claim.getIssuer()+claim.getIssuerName()
                +claim.getIssuanceDate()+claim.getExpirationDate()+claim.getCredentialSubject().getId()+
                claim.getCredentialSubject().getName()+claim.getRevocation().getId();


        PrivateKey key = new PrivateKey(skey);
        ProofBean proof = new ProofBean();
        proof.setCreator(claim.getIssuer());
        proof.setType("edd25519");
        proof.set_$Pubkey58(key.getEncPublicKey());

        proof.setSignatureValue(HexFormat.byteToHex(key.sign(msg.getBytes())));
        List<ProofBean> list = new ArrayList<ProofBean>();
        list.add(proof);
        claim.setProof(list);
        return claim;
    }


    /**
     * @context : ["https://www.w3.org/2018/credentials/v1"]
     * id : KXRZ100001
     * type : ["可信认证"]
     * issuer : did:bid:0:THeNuzzVL5HWartjLpZDZ
     * issuerName : 某某节点
     * issuanceDate : 2017-04-01T12:01:20Z
     * expirationDate : 2017-04-01T12:01:20Z
     * credentialSubject : {"id":"did:bid:0:6cc796b8d6e2fbebc9b3cf9e","name":"某某机构"}
     * revocation : {"id":"https://example.com/v1/claim/revocations"}
     * proof : [{"creator":"did:bid:0:THeNuzzVL5HWartjLpZDZ","type":"Secp256k1","\u201cpubkey\u201d":"\u201d eyJhbGciOiJSUzI1NiIsImI2NCI6ZmFsc2UsImNyaXQiOlsiYjY0\u201d","signatureValue":"eyJhbGciOiJSUzI1NiIsImI2NCI6ZmFsc2UsImNyaXQiOlsiYjY0Il19"}]
     */

    private String id;
    private String issuer;
    private String issuerName;
    private String issuanceDate;
    private String expirationDate;
    private CredentialSubjectBean credentialSubject;
    private RevocationBean revocation;
    @com.google.gson.annotations.SerializedName("@context")
    private List<String> _$Context66; // FIXME check this code
    private List<String> type;
    private List<ProofBean> proof;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIssuer() {
        return issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getIssuerName() {
        return issuerName;
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
    }

    public String getIssuanceDate() {
        return issuanceDate;
    }

    public void setIssuanceDate(String issuanceDate) {
        this.issuanceDate = issuanceDate;
    }

    public String getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public CredentialSubjectBean getCredentialSubject() {
        return credentialSubject;
    }

    public void setCredentialSubject(CredentialSubjectBean credentialSubject) {
        this.credentialSubject = credentialSubject;
    }

    public RevocationBean getRevocation() {
        return revocation;
    }

    public void setRevocation(RevocationBean revocation) {
        this.revocation = revocation;
    }

    public List<String> get_$Context66() {
        return _$Context66;
    }

    public void set_$Context66(List<String> _$Context66) {
        this._$Context66 = _$Context66;
    }

    public List<String> getType() {
        return type;
    }

    public void setType(List<String> type) {
        this.type = type;
    }

    public List<ProofBean> getProof() {
        return proof;
    }

    public void setProof(List<ProofBean> proof) {
        this.proof = proof;
    }

    public static class CredentialSubjectBean {
        /**
         * id : did:bid:0:6cc796b8d6e2fbebc9b3cf9e
         * name : 某某机构
         */

        private String id;
        private String name;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class RevocationBean {
        /**
         * id : https://example.com/v1/claim/revocations
         */

        private String id;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class ProofBean {
        /**
         * creator : did:bid:0:THeNuzzVL5HWartjLpZDZ
         * type : Secp256k1
         * “pubkey” : ” eyJhbGciOiJSUzI1NiIsImI2NCI6ZmFsc2UsImNyaXQiOlsiYjY0”
         * signatureValue : eyJhbGciOiJSUzI1NiIsImI2NCI6ZmFsc2UsImNyaXQiOlsiYjY0Il19
         */

        private String creator;
        private String type;
        @com.google.gson.annotations.SerializedName("“pubkey”")
        private String _$Pubkey58; // FIXME check this code
        private String signatureValue;

        public String getCreator() {
            return creator;
        }

        public void setCreator(String creator) {
            this.creator = creator;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String get_$Pubkey58() {
            return _$Pubkey58;
        }

        public void set_$Pubkey58(String _$Pubkey58) {
            this._$Pubkey58 = _$Pubkey58;
        }

        public String getSignatureValue() {
            return signatureValue;
        }

        public void setSignatureValue(String signatureValue) {
            this.signatureValue = signatureValue;
        }
    }
}
