/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.common.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateDeserializer
extends JsonDeserializer<Date> {
    public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String date = jsonParser.getText();
        if (date.length() == 14) {
            SimpleDateFormat dataFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            try {
                return dataFormat.parse(date);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        long time = Long.valueOf(date) * 1000L;
        return new Date(time);
    }
}

