/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.common;

import com.riversoft.weixin.common.AccessToken;
import com.riversoft.weixin.common.AccessTokenHolder;
import com.riversoft.weixin.common.DefaultAccessTokenHolder;
import com.riversoft.weixin.common.exception.WxError;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxClient {
    private static Logger logger = LoggerFactory.getLogger(WxClient.class);
    protected CloseableHttpClient httpClient;
    private String clientId;
    private String clientSecret;
    private AccessTokenHolder accessTokenHolder;

    public WxClient() {
        this.httpClient = HttpClients.createDefault();
    }

    public WxClient(String tokenUrl, String clientId, String clientSecret) {
        this(clientId, clientSecret, new DefaultAccessTokenHolder(tokenUrl, clientId, clientSecret));
    }

    public WxClient(String clientId, String clientSecret, AccessTokenHolder accessTokenHolder) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.accessTokenHolder = accessTokenHolder;
        this.httpClient = HttpClients.createDefault();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String get(String url) {
        return this.get(url, true);
    }

    public String get(String url, boolean needToken) {
        if (needToken) {
            try {
                return this.httpGet(this.appendAccessToken(url));
            }
            catch (Exception e) {
                WxRuntimeException wxRuntimeException;
                if (e instanceof WxRuntimeException && this.invalidToken((wxRuntimeException = (WxRuntimeException)e).getCode())) {
                    logger.warn("token invalid: {}, will refresh.", (Object)wxRuntimeException.getCode());
                    this.refreshToken();
                    return this.httpGet(this.appendAccessToken(url));
                }
                throw e;
            }
        }
        return this.httpGet(url);
    }

    public byte[] getBinary(String url, boolean needToken) {
        if (needToken) {
            try {
                return this.httpGetBinary(this.appendAccessToken(url));
            }
            catch (Exception e) {
                WxRuntimeException wxRuntimeException;
                if (e instanceof WxRuntimeException && this.invalidToken((wxRuntimeException = (WxRuntimeException)e).getCode())) {
                    logger.warn("token invalid: {}, will refresh.", (Object)wxRuntimeException.getCode());
                    this.refreshToken();
                    return this.httpGetBinary(this.appendAccessToken(url));
                }
                throw e;
            }
        }
        return this.httpGetBinary(url);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] httpGetBinary(String url) {
        HttpGet httpGet = new HttpGet(url);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            String responseContent;
            WxError wxError;
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                EntityUtils.consume((HttpEntity)entity);
                throw new WxRuntimeException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            Header[] contentTypeHeader = response.getHeaders("Content-Type");
            if (contentTypeHeader != null && contentTypeHeader.length > 0 && ContentType.TEXT_PLAIN.getMimeType().equals(contentTypeHeader[0].getValue()) && (wxError = WxError.fromJson(responseContent = entity == null ? null : EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8))).getErrorCode() != 0) {
                throw new WxRuntimeException(wxError);
            }
            InputStream inputStream = response.getEntity().getContent();
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
        catch (IOException ex) {
            logger.error("http get: {} failed.", (Object)url, (Object)ex);
            throw new WxRuntimeException(999, ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String httpGet(String url) {
        HttpGet httpGet = new HttpGet(url);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                EntityUtils.consume((HttpEntity)entity);
                throw new WxRuntimeException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            String responseContent = entity == null ? null : EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            WxError wxError = WxError.fromJson(responseContent);
            if (wxError.getErrorCode() != 0) {
                throw new WxRuntimeException(wxError);
            }
            String string = responseContent;
            return string;
        }
        catch (IOException ex) {
            logger.error("http get: {} failed.", (Object)url, (Object)ex);
            throw new WxRuntimeException(999, ex.getMessage());
        }
    }

    public File download(String url) {
        try {
            return this.httpDownload(this.appendAccessToken(url));
        }
        catch (Exception e) {
            WxRuntimeException wxRuntimeException;
            if (e instanceof WxRuntimeException && this.invalidToken((wxRuntimeException = (WxRuntimeException)e).getCode())) {
                logger.warn("token invalid: {}, will refresh.", (Object)wxRuntimeException.getCode());
                this.refreshToken();
                return this.httpDownload(this.appendAccessToken(url));
            }
            throw e;
        }
    }

    public InputStream copyStream(String url, String post) {
        try {
            return this.httpCopyFromStream(this.appendAccessToken(url), post);
        }
        catch (Exception e) {
            WxRuntimeException wxRuntimeException;
            if (e instanceof WxRuntimeException && this.invalidToken((wxRuntimeException = (WxRuntimeException)e).getCode())) {
                logger.warn("token invalid: {}, will refresh.", (Object)wxRuntimeException.getCode());
                this.refreshToken();
                return this.httpCopyFromStream(this.appendAccessToken(url), post);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream httpCopyFromStream(String url, String post) {
        HttpPost httpPost = new HttpPost(url);
        if (post != null) {
            StringEntity entity = new StringEntity(post, Consts.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
        }
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                EntityUtils.consume((HttpEntity)entity);
                throw new WxRuntimeException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            InputStream inputStream = entity.getContent();
            byte[] binaryContent = IOUtils.toByteArray((InputStream)inputStream);
            String content = new String(binaryContent, "UTF-8");
            if (content.contains("errcode")) {
                WxError wxError = WxError.fromJson(content);
                throw new WxRuntimeException(wxError);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(binaryContent);
            return byteArrayInputStream;
        }
        catch (IOException e) {
            logger.error("http download: {} failed.", (Object)url, (Object)e);
            throw new WxRuntimeException(999, e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File httpDownload(String url) {
        HttpGet httpGet = new HttpGet(url);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                EntityUtils.consume((HttpEntity)entity);
                throw new WxRuntimeException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            Header[] dispositionHeaders = response.getHeaders("Content-disposition");
            if (dispositionHeaders != null && dispositionHeaders.length > 0) {
                String fileName = this.extractFileName(dispositionHeaders[0].getValue());
                if (fileName == null || "".equals(fileName.trim())) {
                    logger.warn("Cannot get filename from Content-disposition");
                    fileName = UUID.randomUUID().toString();
                }
                InputStream inputStream = entity.getContent();
                File tempFile = new File(FileUtils.getTempDirectory(), fileName);
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
                File file = tempFile;
                return file;
            }
            String errors = entity == null ? null : EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            logger.warn("download file : {} failed: {}", (Object)url, (Object)errors);
            if (!errors.contains("errcode")) throw new WxRuntimeException(999, errors);
            WxError wxError = WxError.fromJson(errors);
            throw new WxRuntimeException(wxError);
        }
        catch (IOException e) {
            logger.error("http download: {} failed.", (Object)url, (Object)e);
            throw new WxRuntimeException(999, e.getMessage());
        }
    }

    private String extractFileName(String headerValue) {
        String fileName = null;
        Pattern regex = Pattern.compile("(?<=filename=\").*?(?=\")");
        Matcher regexMatcher = regex.matcher(headerValue);
        if (regexMatcher.find()) {
            fileName = regexMatcher.group();
        }
        return fileName;
    }

    public String post(String url, String content) {
        try {
            return this.httpPost(this.appendAccessToken(url), content);
        }
        catch (Exception e) {
            WxRuntimeException wxRuntimeException;
            if (e instanceof WxRuntimeException && this.invalidToken((wxRuntimeException = (WxRuntimeException)e).getCode())) {
                logger.warn("token invalid: {}, will refresh.", (Object)wxRuntimeException.getCode());
                this.refreshToken();
                return this.httpPost(this.appendAccessToken(url), content);
            }
            throw e;
        }
    }

    public String post(String url, InputStream inputStream, String fileName, Map<String, String> form) {
        File tempFile = new File(FileUtils.getTempDirectory(), fileName);
        try {
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
        }
        catch (IOException e) {
            logger.error("http post: {} failed", (Object)url, (Object)e);
            throw new WxRuntimeException(999, "Copy stream to file failed:" + e.getMessage());
        }
        try {
            String e = this.httpPost(this.appendAccessToken(url), tempFile, form);
            return e;
        }
        catch (Exception e) {
            WxRuntimeException wxRuntimeException;
            if (e instanceof WxRuntimeException && this.invalidToken((wxRuntimeException = (WxRuntimeException)e).getCode())) {
                logger.warn("token invalid: {}, will refresh.", (Object)wxRuntimeException.getCode());
                this.refreshToken();
                String string = this.httpPost(this.appendAccessToken(url), tempFile, form);
                return string;
            }
            throw e;
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    public String post(String url, InputStream inputStream, String fileName) {
        return this.post(url, inputStream, fileName, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String httpPost(String url, String content) {
        HttpPost httpPost = new HttpPost(url);
        if (content != null) {
            StringEntity entity = new StringEntity(content, Consts.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
        }
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                EntityUtils.consume((HttpEntity)entity);
                throw new WxRuntimeException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            String responseContent = entity == null ? null : EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            WxError wxError = WxError.fromJson(responseContent);
            if (wxError.getErrorCode() != 0) {
                throw new WxRuntimeException(wxError);
            }
            String string = responseContent;
            return string;
        }
        catch (IOException ex) {
            logger.error("http post: {} failed", (Object)url, (Object)ex);
            throw new WxRuntimeException(999, ex.getMessage());
        }
    }

    private String httpPost(String url, File file) {
        return this.httpPost(url, file, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String httpPost(String url, File file, Map<String, String> form) {
        HttpPost httpPost = new HttpPost(url);
        if (file != null) {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.addBinaryBody("media", file).setMode(HttpMultipartMode.RFC6532);
            if (form != null && !form.isEmpty()) {
                for (String key : form.keySet()) {
                    multipartEntityBuilder.addTextBody(key, form.get(key));
                }
            }
            httpPost.setEntity(multipartEntityBuilder.build());
            httpPost.setHeader("Content-Type", ContentType.MULTIPART_FORM_DATA.toString());
        }
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            Object object = null;
            try {
                StatusLine statusLine = response.getStatusLine();
                HttpEntity entity = response.getEntity();
                if (statusLine.getStatusCode() >= 300) {
                    EntityUtils.consume((HttpEntity)entity);
                    throw new WxRuntimeException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                }
                String string = entity == null ? null : EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
                return string;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (response != null) {
                    if (object != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            logger.error("http post: {} failed", (Object)url, (Object)ex);
            throw new WxRuntimeException(999, ex.getMessage());
        }
    }

    private String appendAccessToken(String url) {
        String token = this.accessTokenHolder.getAccessToken().getAccessToken();
        logger.debug("[{}]:access token: {}", (Object)this.clientId, (Object)token);
        return url + (url.indexOf(63) == -1 ? "?access_token=" + token : "&access_token=" + token);
    }

    public void refreshToken() {
        this.accessTokenHolder.refreshToken();
    }

    public AccessToken getAccessToken() {
        return this.accessTokenHolder.getAccessToken();
    }

    private boolean invalidToken(int code) {
        boolean result;
        boolean bl = result = code == 42001 || code == 40001 || code == 40014;
        if (result) {
            this.accessTokenHolder.expireToken();
        }
        return result;
    }
}

