/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.common;

import com.riversoft.weixin.common.AccessToken;
import com.riversoft.weixin.common.exception.WxError;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccessTokenHolder {
    private static Logger logger = LoggerFactory.getLogger(AccessTokenHolder.class);
    private String clientId;
    private String clientSecret;
    private String tokenUrl;
    private CloseableHttpClient httpClient;

    public AccessTokenHolder(String tokenUrl, String clientId, String clientSecret) {
        this.tokenUrl = tokenUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.httpClient = HttpClients.createDefault();
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String fetchAccessToken() {
        logger.debug("[{}]:fetching a new access token.", (Object)this.clientId);
        String url = String.format(this.tokenUrl, this.clientId, this.clientSecret);
        HttpGet httpGet = new HttpGet(url);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                EntityUtils.consume((HttpEntity)entity);
                throw new WxRuntimeException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            String responseContent = entity == null ? null : EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            WxError wxError = WxError.fromJson(responseContent);
            if (wxError.getErrorCode() != 0) {
                throw new WxRuntimeException(wxError);
            }
            String string = responseContent;
            return string;
        }
        catch (IOException ex) {
            logger.error("fetching a new token failed: {} failed.", (Object)url, (Object)ex);
            throw new WxRuntimeException(999, ex.getMessage());
        }
    }

    public abstract AccessToken getAccessToken();

    public abstract void refreshToken();

    public abstract void expireToken();
}

