/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.riversoft.weixin.common.util.JsonMapper;

public class AccessToken {
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="expires_in")
    private long expiresIn;
    private long expiresTill;

    public static AccessToken fromJson(String json) {
        return JsonMapper.defaultMapper().fromJson(json, AccessToken.class);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
        this.expiresTill = System.currentTimeMillis() + expiresIn * 1000L - 300000L;
    }

    public long getExpiresTill() {
        return this.expiresTill;
    }

    public boolean expired() {
        return System.currentTimeMillis() > this.expiresTill;
    }
}

