package cn.bestwu.apidoc.starter

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.beans.factory.annotation.Value
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.boot.context.properties.EnableConfigurationProperties
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import javax.annotation.PostConstruct

/**
 * @author Peter Wu
 * @since 1.3.8
 */
@ConditionalOnProperty(prefix = "api.apidoc", name = ["enable"], havingValue = "true")
@EnableConfigurationProperties(GeneratorProperties::class, ApidocProperties::class)
@Configuration
class ApiDocConfiguration {
    @Autowired
    private lateinit var generatorProperties: GeneratorProperties
    @Autowired
    private lateinit var apidocProperties: ApidocProperties
    @Value("\${spring.application.name:}")
    private lateinit var projectName: String

    @PostConstruct
    fun init() {
        if (apidocProperties.projectName.isBlank()) {
            apidocProperties.projectName = projectName
        }
    }

    @Bean
    fun apiDocHandler(): ApiDocHandler {
        return ApiDocHandler(generatorProperties, apidocProperties)
    }

}
