/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.apidoc.starter;

import cn.bestwu.apidoc.starter.ApiDocHandler;
import cn.bestwu.apidoc.starter.ApidocProperties;
import cn.bestwu.apidoc.starter.GeneratorProperties;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(prefix="api.apidoc", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={GeneratorProperties.class, ApidocProperties.class})
@Configuration
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u000b\u001a\u00020\fH\u0017R\u0012\u0010\u0003\u001a\u00020\u00048\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcn/bestwu/apidoc/starter/ApiDocConfiguration;", "", "()V", "apidocProperties", "Lcn/bestwu/apidoc/starter/ApidocProperties;", "generatorProperties", "Lcn/bestwu/apidoc/starter/GeneratorProperties;", "projectName", "", "apiDocHandler", "Lcn/bestwu/apidoc/starter/ApiDocHandler;", "init", "", "starter-apidoc"})
public class ApiDocConfiguration {
    @Autowired
    private GeneratorProperties generatorProperties;
    @Autowired
    private ApidocProperties apidocProperties;
    @Value(value="${spring.application.name:}")
    private String projectName;

    @PostConstruct
    public void init() {
        ApidocProperties apidocProperties = this.apidocProperties;
        if (apidocProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apidocProperties");
        }
        if (StringsKt.isBlank((CharSequence)apidocProperties.getProjectName())) {
            ApidocProperties apidocProperties2 = this.apidocProperties;
            if (apidocProperties2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"apidocProperties");
            }
            String string = this.projectName;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectName");
            }
            apidocProperties2.setProjectName(string);
        }
    }

    @Bean
    @NotNull
    public ApiDocHandler apiDocHandler() {
        GeneratorProperties generatorProperties = this.generatorProperties;
        if (generatorProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generatorProperties");
        }
        ApidocProperties apidocProperties = this.apidocProperties;
        if (apidocProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apidocProperties");
        }
        return new ApiDocHandler(generatorProperties, apidocProperties);
    }
}

