package cn.bestwu.apidoc.starter

/**
 * 接口文档数据模型
 */
object ApiDoc {
    /**
     * 模块
     */
    var docModule: String = "_t"
    /**
     * 资源名称
     */
    var resource: String = ""
    /**
     * 接口名称
     */
    var name: String = ""
    /**
     * 相关数据表名
     */
    var tableNames: Array<String> = arrayOf()

    /**
     * 必填参数
     */
    var requires: Array<out String> = arrayOf()
    /**
     * 请求头必填参数
     */
    var headerRequires: Array<out String> = arrayOf("sign")
    /**
     * 请求头
     */
    var headers: Array<out String> = arrayOf("sign")
    /**
     * 是否启用文档数据生成
     */
    var enable: Boolean = false
    /**
     * 开发者
     */
    var author: String = ""
    /**
     * 接口描述
     */
    var desc: String = ""
    var schema: String? = null


    /**
     * 相关数据表名
     */
    fun tableNames(vararg tableName: String) {
        tableNames = tableName.toList().toTypedArray()
    }

    /**
     * 必填参数
     */
    fun requires(vararg require: String) {
        requires = require
    }

    /**
     * 请求头必填参数
     */
    fun headerRequires(vararg headerRequire: String) {
        headerRequires = headerRequire
    }

    /**
     * 请求头
     */
    fun headers(vararg header: String) {
        headers = header
    }

    /**
     * 是否启用文档数据生成
     */
    fun enable() {
        enable = true
    }
}
