/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.apidoc.starter;

import cn.bestwu.apidoc.starter.ApiDocFilter;
import cn.bestwu.apidoc.starter.ApiDocHandlerInterceptor;
import cn.bestwu.apidoc.starter.ApidocProperties;
import cn.bestwu.apidoc.starter.GeneratorProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Conditional(value={ApiDocCondition.class})
@EnableConfigurationProperties(value={GeneratorProperties.class, ApidocProperties.class})
@Configuration
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0017R\u0012\u0010\u0003\u001a\u00020\u00048\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcn/bestwu/apidoc/starter/ApiDocConfiguration;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurerAdapter;", "()V", "apidocProperties", "Lcn/bestwu/apidoc/starter/ApidocProperties;", "generatorProperties", "Lcn/bestwu/apidoc/starter/GeneratorProperties;", "addInterceptors", "", "registry", "Lorg/springframework/web/servlet/config/annotation/InterceptorRegistry;", "apidocFilter", "Lcn/bestwu/apidoc/starter/ApiDocFilter;", "ApiDocCondition", "starter-apidoc"})
public class ApiDocConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    private GeneratorProperties generatorProperties;
    @Autowired
    private ApidocProperties apidocProperties;

    @Bean
    @NotNull
    public ApiDocFilter apidocFilter() {
        GeneratorProperties generatorProperties = this.generatorProperties;
        if (generatorProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generatorProperties");
        }
        ApidocProperties apidocProperties = this.apidocProperties;
        if (apidocProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apidocProperties");
        }
        return new ApiDocFilter(generatorProperties, apidocProperties);
    }

    public void addInterceptors(@NotNull InterceptorRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        ApidocProperties apidocProperties = this.apidocProperties;
        if (apidocProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apidocProperties");
        }
        registry.addInterceptor((HandlerInterceptor)new ApiDocHandlerInterceptor(apidocProperties));
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcn/bestwu/apidoc/starter/ApiDocConfiguration$ApiDocCondition;", "Lorg/springframework/context/annotation/Condition;", "()V", "matches", "", "context", "Lorg/springframework/context/annotation/ConditionContext;", "metadata", "Lorg/springframework/core/type/AnnotatedTypeMetadata;", "starter-apidoc"})
    public static final class ApiDocCondition
    implements Condition {
        public boolean matches(@NotNull ConditionContext context, @NotNull AnnotatedTypeMetadata metadata) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)metadata, (String)"metadata");
            return StringUtils.hasText((String)context.getEnvironment().getProperty("api.apidoc.handler-type-prefix")) || StringUtils.hasText((String)context.getEnvironment().getProperty("api.apidoc.handlerTypePrefix"));
        }
    }
}

