/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web.xss;

import cn.bestwu.simpleframework.web.xss.HTMLFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final HTMLFilter htmlFilter = new HTMLFilter();
    final HttpServletRequest orgRequest;

    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.orgRequest = request;
    }

    public static HttpServletRequest getOrgRequest(HttpServletRequest request) {
        if (request instanceof XssHttpServletRequestWrapper) {
            return ((XssHttpServletRequestWrapper)request).getOrgRequest();
        }
        return request;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (!"application/json".equalsIgnoreCase(super.getHeader("Content-Type"))) {
            return super.getInputStream();
        }
        String json = StreamUtils.copyToString((InputStream)super.getInputStream(), (Charset)Charset.forName("utf-8"));
        if (!StringUtils.hasText((String)json)) {
            return super.getInputStream();
        }
        json = this.xssEncode(json);
        final ByteArrayInputStream bis = new ByteArrayInputStream(json.getBytes("utf-8"));
        return new ServletInputStream(){

            public boolean isFinished() {
                return true;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                return bis.read();
            }
        };
    }

    public String getParameter(String name) {
        String value = super.getParameter(this.xssEncode(name));
        if (StringUtils.hasText((String)value)) {
            value = this.xssEncode(value);
        }
        return value;
    }

    public String[] getParameterValues(String name) {
        String[] parameters = super.getParameterValues(name);
        if (parameters == null || parameters.length == 0) {
            return null;
        }
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.xssEncode(parameters[i]);
        }
        return parameters;
    }

    public Map<String, String[]> getParameterMap() {
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        Map parameters = super.getParameterMap();
        for (String key : parameters.keySet()) {
            String[] values = (String[])parameters.get(key);
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.xssEncode(values[i]);
            }
            map.put(key, values);
        }
        return map;
    }

    public String getHeader(String name) {
        String value = super.getHeader(this.xssEncode(name));
        if (StringUtils.hasText((String)value)) {
            value = this.xssEncode(value);
        }
        return value;
    }

    private String xssEncode(String input) {
        return htmlFilter.filter(input);
    }

    public HttpServletRequest getOrgRequest() {
        return this.orgRequest;
    }
}

