/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web.validator;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class IDCardUtil {
    private static final int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final String[] verifyCode = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};

    public static boolean validate(String idcard) {
        if (idcard == null) {
            return false;
        }
        if (idcard.length() == 15) {
            idcard = IDCardUtil.convertFrom15bit(idcard);
        }
        if (idcard == null) {
            return false;
        }
        if (idcard.length() != 18) {
            return false;
        }
        String idcard17 = idcard.substring(0, 17);
        String idcard18Code = idcard.substring(17, 18);
        if (IDCardUtil.isDigital(idcard17)) {
            char[] c = idcard17.toCharArray();
            int[] bit = IDCardUtil.converCharToInt(c);
            int sum17 = IDCardUtil.getPowerSum(bit);
            String checkCode = IDCardUtil.getCheckCodeBySum(sum17);
            if (null == checkCode) {
                return false;
            }
            return idcard18Code.equalsIgnoreCase(checkCode);
        }
        return false;
    }

    public static String convertFrom15bit(String idcard) {
        if (idcard.length() != 15) {
            return null;
        }
        if (IDCardUtil.isDigital(idcard)) {
            try {
                String birthday = idcard.substring(6, 12);
                Date birthdate = new SimpleDateFormat("yyMMdd").parse(birthday);
                Calendar cday = Calendar.getInstance();
                cday.setTime(birthdate);
                String year = String.valueOf(cday.get(1));
                String idcard17 = idcard.substring(0, 6) + year + idcard.substring(8);
                char[] c = idcard17.toCharArray();
                int[] bit = IDCardUtil.converCharToInt(c);
                int sum17 = IDCardUtil.getPowerSum(bit);
                String checkCode = IDCardUtil.getCheckCodeBySum(sum17);
                if (null == checkCode) {
                    return null;
                }
                idcard17 = idcard17 + checkCode;
                return idcard17;
            }
            catch (NumberFormatException | ParseException e) {
                return null;
            }
        }
        return null;
    }

    private static boolean isDigital(String str) {
        return str != null && !"".equals(str) && str.matches("^[0-9]*$");
    }

    private static int getPowerSum(int[] bit) {
        int sum = 0;
        if (power.length != bit.length) {
            return sum;
        }
        for (int i = 0; i < bit.length; ++i) {
            for (int j = 0; j < power.length; ++j) {
                if (i != j) continue;
                sum += bit[i] * power[j];
            }
        }
        return sum;
    }

    private static String getCheckCodeBySum(int sum17) {
        return verifyCode[sum17 % 11];
    }

    private static int[] converCharToInt(char[] c) throws NumberFormatException {
        int[] a = new int[c.length];
        int k = 0;
        for (char temp : c) {
            a[k++] = Integer.parseInt(String.valueOf(temp));
        }
        return a;
    }
}

