/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web.serializer;

import cn.bestwu.simpleframework.web.serializer.JsonUrlMapper;
import cn.bestwu.simpleframework.web.serializer.annotation.JsonUrl;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@JacksonStdImpl
public class UrlSerializer
extends StdScalarSerializer<Object>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    private static String defaultFormatExpression = "${app.multipart.file-url-format}";
    private static JsonUrlMapper defaultMapper = new JsonUrlMapper(){};
    private static Environment environment;
    private static Map<String, String> formatCache;
    private static Map<Class<? extends JsonUrlMapper>, JsonUrlMapper> mapperCache;
    private static String defaultFormat;
    private String formatExpression;
    private boolean useExtensionField;
    private String separator;
    private Class<? extends JsonUrlMapper> mapperType;

    public UrlSerializer() {
        this(null, true, "", null);
    }

    public UrlSerializer(String formatExpression, boolean useExtensionField, String separator, Class<? extends JsonUrlMapper> mapperType) {
        super(Object.class, false);
        this.formatExpression = formatExpression;
        this.useExtensionField = useExtensionField;
        this.separator = separator;
        this.mapperType = mapperType;
    }

    public static void setDefaultFormatExpression(String defaultFormatExpression) {
        UrlSerializer.defaultFormatExpression = defaultFormatExpression;
    }

    public static void setEnvironment(Environment environment) {
        UrlSerializer.environment = environment;
        defaultFormat = environment.resolvePlaceholders(defaultFormatExpression);
    }

    public static String convert(String path, String formatExpression) {
        if (StringUtils.hasText((String)path)) {
            String format;
            if (StringUtils.hasText((String)formatExpression)) {
                format = formatCache.get(formatExpression);
                if (format == null) {
                    format = environment.resolvePlaceholders(formatExpression);
                    formatCache.put(formatExpression, format);
                }
            } else {
                format = defaultFormat;
            }
            return String.format(format, path);
        }
        return path;
    }

    public static String convert(String path) {
        return UrlSerializer.convert(path, null);
    }

    private JsonUrlMapper getMapper() {
        if (this.mapperType == null || this.mapperType.equals(JsonUrlMapper.class)) {
            return defaultMapper;
        }
        JsonUrlMapper jsonUrlMapper = mapperCache.get(this.mapperType);
        if (jsonUrlMapper == null) {
            try {
                jsonUrlMapper = this.mapperType.newInstance();
                mapperCache.put(this.mapperType, jsonUrlMapper);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("mapper\u5b9e\u4f8b\u5316\u5931\u8d25", e);
            }
        }
        return jsonUrlMapper;
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Class<?> type = value.getClass();
        JsonUrlMapper mapper = this.getMapper();
        if (type == String.class) {
            if (this.separator.isEmpty()) {
                String path = mapper.mapper(value);
                if (this.useExtensionField) {
                    JsonStreamContext outputContext = gen.getOutputContext();
                    String fieldName = outputContext.getCurrentName();
                    gen.writeString(path);
                    gen.writeStringField(fieldName + "Url", UrlSerializer.convert(path, this.formatExpression));
                } else {
                    gen.writeString(UrlSerializer.convert(path, this.formatExpression));
                }
            } else {
                String path = (String)value;
                Object[] split = path.split(this.separator);
                this.genArray(path, gen, mapper, split);
            }
        } else if (type.isArray()) {
            Object[] array = (Object[])value;
            this.genArray(value, gen, mapper, array);
        } else if (Collection.class.isAssignableFrom(type) && !Map.class.isAssignableFrom(type)) {
            Collection array = (Collection)value;
            List<String> urls = array.stream().map(mapper::mapper).filter(StringUtils::hasText).map(o -> UrlSerializer.convert(o, this.formatExpression)).collect(Collectors.toList());
            this.genCollection(value, gen, urls);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void genArray(Object value, JsonGenerator gen, JsonUrlMapper mapper, Object[] array) throws IOException {
        List<String> urls = Arrays.stream(array).map(mapper::mapper).filter(StringUtils::hasText).map(s -> UrlSerializer.convert(s, this.formatExpression)).collect(Collectors.toList());
        this.genCollection(value, gen, urls);
    }

    private void genCollection(Object value, JsonGenerator gen, List<String> urls) throws IOException {
        if (this.useExtensionField) {
            gen.writeObject(value);
            JsonStreamContext outputContext = gen.getOutputContext();
            String fieldName = outputContext.getCurrentName();
            gen.writeObjectField(fieldName + "Urls", urls);
        } else {
            gen.writeObject(urls);
        }
    }

    public final void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(value, gen, provider);
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        if (property != null) {
            JsonUrl annotation = (JsonUrl)property.getAnnotation(JsonUrl.class);
            if (annotation == null) {
                throw new RuntimeException("\u672a\u6ce8\u89e3@" + JsonUrl.class.getName());
            }
            return new UrlSerializer(annotation.value(), annotation.extended(), annotation.separator(), annotation.mapper());
        }
        return this;
    }

    static {
        formatCache = new HashMap<String, String>();
        mapperCache = new HashMap<Class<? extends JsonUrlMapper>, JsonUrlMapper>();
    }
}

