/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;

@JacksonStdImpl
public class RestDateSerializer
extends StdScalarSerializer<Date> {
    private static final long serialVersionUID = 1L;

    public RestDateSerializer() {
        super(Date.class, false);
    }

    public boolean isEmpty(SerializerProvider provider, Date value) {
        return false;
    }

    public JsonNode getSchema(SerializerProvider serializers, Type typeHint) {
        return this.createSchemaNode("number", true);
    }

    public void serialize(Date value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeNumber(this.daysOfTwo(new Date(), value));
    }

    private long daysOfTwo(Date fDate, Date oDate) {
        LocalDateTime localDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(fDate.getTime()), ZoneOffset.of("+8"));
        LocalDateTime localDate2 = LocalDateTime.ofInstant(Instant.ofEpochMilli(oDate.getTime()), ZoneOffset.of("+8"));
        long days = localDate2.toLocalDate().toEpochDay() - localDate.toLocalDate().toEpochDay();
        return days >= 0L ? days : 0L;
    }
}

