/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web.serializer;

import cn.bestwu.simpleframework.web.serializer.NullDefaultSerializer;
import cn.bestwu.simpleframework.web.serializer.annotation.JsonDefault;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.util.List;

public class CustomNullSerializerModifier
extends BeanSerializerModifier {
    private boolean useDefault;

    public CustomNullSerializerModifier(boolean useDefault) {
        this.useDefault = useDefault;
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        for (BeanPropertyWriter writer : beanProperties) {
            if (writer.hasNullSerializer()) continue;
            Class rawClass = writer.getType().getRawClass();
            JsonDefault annotation = (JsonDefault)writer.getAnnotation(JsonDefault.class);
            String value = "";
            if (annotation != null) {
                value = annotation.value();
            }
            if ((!this.useDefault || !NullDefaultSerializer.support(rawClass)) && annotation == null) continue;
            writer.assignNullSerializer((JsonSerializer)new NullDefaultSerializer(rawClass, value));
        }
        return beanProperties;
    }
}

