/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web.resolver.multipart;

import cn.bestwu.lang.util.FilenameUtil;
import cn.bestwu.simpleframework.web.resolver.multipart.Attachment;
import cn.bestwu.simpleframework.web.resolver.multipart.MultipartProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.HandlerMapping;

public class MuipartFileToAttachmentConverter
implements Converter<MultipartFile, Attachment> {
    public static final String REQUEST_FILES = "REQUEST_FILES";
    private Logger log = LoggerFactory.getLogger(MuipartFileToAttachmentConverter.class);
    private final MultipartProperties multipartProperties;

    public MuipartFileToAttachmentConverter(MultipartProperties multipartProperties) {
        this.multipartProperties = multipartProperties;
    }

    public Attachment convert(MultipartFile source) {
        try {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = requestAttributes.getRequest();
            String name = source.getName();
            if (source.isEmpty()) {
                throw new IllegalArgumentException("\u4e0d\u80fd\u4e0a\u4f20\u7a7a\u6587\u4ef6");
            }
            Map uriVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            String filePath = "/" + (String)uriVariables.values().iterator().next() + "/";
            filePath = filePath + LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE);
            String originalFilename = source.getOriginalFilename();
            String path = filePath;
            if (StringUtils.hasText((String)originalFilename)) {
                String nameWithoutExtension = StringUtils.trimAllWhitespace((String)FilenameUtil.getNameWithoutExtension((String)originalFilename));
                path = filePath + "/" + URLEncoder.encode(nameWithoutExtension, "UTF-8") + "." + System.currentTimeMillis() + "." + FilenameUtil.getExtension((String)originalFilename);
                filePath = filePath + "/" + nameWithoutExtension + "." + System.currentTimeMillis() + "." + FilenameUtil.getExtension((String)originalFilename);
            } else {
                path = filePath = filePath + "/" + UUID.randomUUID().toString();
            }
            String baseSavePath = this.multipartProperties.getBaseSavePath();
            File dest = new File(baseSavePath, filePath);
            File parentFile = dest.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            StreamUtils.copy((InputStream)source.getInputStream(), (OutputStream)new FileOutputStream(dest));
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u4e0a\u4f20\u6587\u4ef6\u4fdd\u5b58\u81f3\uff1a" + dest.getAbsolutePath());
            }
            Attachment attachment = new Attachment(originalFilename, path, dest);
            MultiValueMap files = (MultiValueMap)request.getAttribute(REQUEST_FILES);
            if (files == null) {
                files = new LinkedMultiValueMap();
                request.setAttribute(REQUEST_FILES, (Object)files);
            }
            files.add((Object)name, (Object)attachment);
            return attachment;
        }
        catch (Exception e) {
            this.cleanFile();
            this.log.error("\u8f6c\u5b58\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("\u8f6c\u5b58\u6587\u4ef6\u5931\u8d25");
        }
    }

    public void cleanFile() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        MultiValueMap files = (MultiValueMap)request.getAttribute(REQUEST_FILES);
        if (files != null) {
            for (List attachments : files.values()) {
                for (Attachment attachment : attachments) {
                    attachment.delete();
                }
            }
        }
    }
}

