/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web.resolver;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.StringUtils;

public class JsonStringConverter
implements ConditionalGenericConverter {
    private Logger log = LoggerFactory.getLogger(JsonStringConverter.class);
    private ObjectMapper objectMapper;

    public JsonStringConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return true;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, Collection.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (!StringUtils.hasText((String)((String)source))) {
            return null;
        }
        CollectionType collectionType = TypeFactory.defaultInstance().constructCollectionType(List.class, targetType.getResolvableType().resolveGeneric(new int[]{0}));
        try {
            return this.objectMapper.readValue((String)source, (JavaType)collectionType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

