/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web;

import cn.bestwu.simpleframework.exception.BusinessException;
import cn.bestwu.simpleframework.exception.ResourceNotFoundException;
import cn.bestwu.simpleframework.support.excel.ExcelImportException;
import cn.bestwu.simpleframework.web.IErrorHandler;
import cn.bestwu.simpleframework.web.RespEntity;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.context.MessageSource;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MultipartException;

@Order(value=-2147483648)
public class ErrorAttributes
extends DefaultErrorAttributes {
    @Autowired
    private MessageSource messageSource;
    private List<IErrorHandler> errorHandlers;

    public ErrorAttributes(List<IErrorHandler> errorHandlers) {
        this.errorHandlers = errorHandlers;
    }

    public Map<String, Object> getErrorAttributes(WebRequest webRequest, boolean includeStackTrace) {
        String message;
        String statusCode = null;
        Integer httpStatusCode = null;
        Throwable error = this.getError(webRequest);
        RespEntity respEntity = new RespEntity();
        Map<String, String> errors = respEntity.getErrors();
        if (error != null) {
            BindException er;
            message = error.getMessage();
            if (this.errorHandlers != null) {
                for (IErrorHandler errorHandler : this.errorHandlers) {
                    errorHandler.handlerException(error, respEntity);
                }
            }
            if (respEntity.containsKey("status")) {
                statusCode = respEntity.getStatus();
            }
            if (respEntity.containsKey("message")) {
                message = respEntity.getMessage();
            }
            if (includeStackTrace) {
                this.addStackTrace(respEntity, error);
            }
            if (error instanceof ResourceNotFoundException) {
                httpStatusCode = HttpStatus.NOT_FOUND.value();
                if (!StringUtils.hasText((String)message)) {
                    message = "resource.not.found";
                }
            } else if (error instanceof HttpRequestMethodNotSupportedException) {
                httpStatusCode = HttpStatus.METHOD_NOT_ALLOWED.value();
                if (!StringUtils.hasText((String)message)) {
                    message = "method.not.allowed";
                }
            } else if (error instanceof BindException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                er = (BindException)error;
                List fieldErrors = er.getFieldErrors();
                for (FieldError fieldError : fieldErrors) {
                    String field;
                    String defaultMessage = fieldError.getDefaultMessage();
                    if (defaultMessage.contains("required type")) {
                        defaultMessage = this.getText(webRequest, fieldError.getCode(), new Object[0]);
                    }
                    String msg = (field = fieldError.getField()).contains(".") ? this.getText(webRequest, field.substring(field.lastIndexOf(46) + 1), new Object[0]) + ":" + defaultMessage : this.getText(webRequest, field, new Object[0]) + ":" + defaultMessage;
                    errors.put(field, msg);
                }
                message = errors.values().iterator().next();
                if (!StringUtils.hasText((String)message)) {
                    message = "data.valid.failed";
                }
            } else if (error instanceof IllegalArgumentException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                if (!StringUtils.hasText((String)message)) {
                    message = "data.valid.failed";
                }
            } else if (error instanceof MethodArgumentTypeMismatchException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                message = "typeMismatch";
            } else if (error instanceof MissingServletRequestParameterException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
            } else if (error instanceof ConversionFailedException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                message = this.getText(webRequest, "typeMismatch", ((ConversionFailedException)error).getValue(), ((ConversionFailedException)error).getTargetType());
                if (!StringUtils.hasText((String)message)) {
                    message = "data.valid.failed";
                }
            } else if (error instanceof ConstraintViolationException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                er = (ConstraintViolationException)error;
                Set constraintViolations = er.getConstraintViolations();
                Iterator iterator = constraintViolations.iterator();
                while (iterator.hasNext()) {
                    ConstraintViolation constraintViolation = (ConstraintViolation)iterator.next();
                    String property = ErrorAttributes.getProperty(constraintViolation);
                    errors.put(property, this.getText(webRequest, property, new Object[0]) + ":" + constraintViolation.getMessage());
                }
                message = errors.values().iterator().next();
                if (!StringUtils.hasText((String)message)) {
                    message = "data.valid.failed";
                }
            } else if (error instanceof HttpMediaTypeNotAcceptableException) {
                httpStatusCode = HttpStatus.NOT_ACCEPTABLE.value();
                message = "MediaType not Acceptable!Must ACCEPT:" + ((HttpMediaTypeNotAcceptableException)error).getSupportedMediaTypes();
            } else if (error instanceof IllegalStateException) {
                httpStatusCode = HttpStatus.CONFLICT.value();
            } else if (error instanceof MultipartException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                message = "upload.fail";
            } else if (error instanceof NullPointerException) {
                message = "NullPointerException";
            } else if (error instanceof HttpMessageNotWritableException) {
                if (message.contains("Session is closed")) {
                    httpStatusCode = HttpStatus.REQUEST_TIMEOUT.value();
                    message = "request.timeout";
                }
            } else if (error instanceof ExcelImportException) {
                httpStatusCode = HttpStatus.UNPROCESSABLE_ENTITY.value();
                List<ExcelImportException.CellError> cellErrors = ((ExcelImportException)error).getErrors();
                for (ExcelImportException.CellError cellError : cellErrors) {
                    String key = "\u7b2c" + cellError.getRow() + "\u884c\u7b2c" + (char)(65 + cellError.getColumn()) + "\u5217";
                    String title = cellError.getTitle();
                    Exception value = cellError.getException();
                    if (value instanceof ConstraintViolationException) {
                        for (ConstraintViolation constraintViolation : ((ConstraintViolationException)value).getConstraintViolations()) {
                            errors.put(key, title + constraintViolation.getMessage());
                        }
                        continue;
                    }
                    errors.put(key, title + this.getText(webRequest, value.getMessage(), new Object[0]));
                }
                Map.Entry<String, String> firstError = errors.entrySet().iterator().next();
                message = firstError.getKey() + ":" + firstError.getValue();
            } else if (error instanceof BusinessException) {
                statusCode = ((BusinessException)error).getCode();
                respEntity.setData(((BusinessException)error).getData());
            }
            if (respEntity.getHttpStatus() != null) {
                httpStatusCode = respEntity.getHttpStatus().value();
            }
        } else {
            message = ErrorAttributes.getMessage((RequestAttributes)webRequest);
        }
        if (httpStatusCode == null) {
            ResponseStatus responseStatus;
            if (error != null && (responseStatus = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(error.getClass(), ResponseStatus.class)) != null) {
                httpStatusCode = responseStatus.code().value();
                String reason = responseStatus.reason();
                if (!StringUtils.hasText((String)message) && StringUtils.hasText((String)reason)) {
                    message = reason;
                }
            }
            if (httpStatusCode == null) {
                httpStatusCode = ErrorAttributes.getStatus((RequestAttributes)webRequest).value();
            }
        }
        String string = statusCode = statusCode == null ? String.valueOf(httpStatusCode) : statusCode;
        if (!StringUtils.hasText((String)message)) {
            message = httpStatusCode == 404 ? "Page not found" : "No message available";
        }
        message = this.getText(webRequest, message, new Object[0]);
        ErrorAttributes.setErrorInfo(webRequest, httpStatusCode, message, error);
        respEntity.setStatus(statusCode);
        respEntity.setMessage(message);
        respEntity.setErrors();
        return respEntity;
    }

    @NotNull
    public static String getProperty(ConstraintViolation<?> constraintViolation) {
        Path propertyPath = constraintViolation.getPropertyPath();
        String property = propertyPath.toString();
        if (propertyPath instanceof PathImpl) {
            property = ((PathImpl)propertyPath).getLeafNode().getName();
        }
        if (property.contains(".")) {
            property = property.substring(property.lastIndexOf(46) + 1);
        }
        return property;
    }

    public static void setErrorInfo(WebRequest request, Integer httpStatusCode, String message, Throwable error) {
        request.setAttribute("javax.servlet.error.status_code", (Object)httpStatusCode, 0);
        request.setAttribute(DefaultErrorAttributes.class.getName() + ".ERROR", (Object)error, 0);
        request.setAttribute("javax.servlet.error.message", (Object)message, 0);
    }

    private void addStackTrace(RespEntity respEntity, Throwable error) {
        StringWriter stackTrace = new StringWriter();
        error.printStackTrace(new PrintWriter(stackTrace));
        stackTrace.flush();
        respEntity.setTrace(stackTrace.toString());
    }

    public static HttpStatus getStatus(RequestAttributes requestAttributes) {
        Integer statusCode = (Integer)ErrorAttributes.getAttribute(requestAttributes, "javax.servlet.error.status_code");
        if (statusCode != null) {
            try {
                return HttpStatus.valueOf((int)statusCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }

    public static String getMessage(RequestAttributes requestAttributes) {
        return (String)ErrorAttributes.getAttribute(requestAttributes, "javax.servlet.error.message");
    }

    private static <T> T getAttribute(RequestAttributes requestAttributes, String name) {
        return (T)requestAttributes.getAttribute(name, 0);
    }

    private String getText(WebRequest webRequest, Object code, Object ... args) {
        String codeString = String.valueOf(code);
        return this.messageSource.getMessage(codeString, args, codeString, webRequest == null ? Locale.CHINA : webRequest.getLocale());
    }
}

