/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.web;

import cn.bestwu.simpleframework.support.LocalDateTimeHelper;
import cn.bestwu.simpleframework.web.ICaptchaService;
import cn.bestwu.simpleframework.web.kaptcha.KaptchaProperties;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class DefaultCaptchaServiceImpl
implements ICaptchaService {
    protected HttpSession httpSession;
    private KaptchaProperties kaptchaProperties;

    public DefaultCaptchaServiceImpl(@Autowired(required=false) HttpSession httpSession, KaptchaProperties kaptchaProperties) {
        this.kaptchaProperties = kaptchaProperties;
        this.httpSession = httpSession;
    }

    @Override
    public void save(String loginId, String captcha) {
        this.httpSession.setAttribute("KAPTCHA_SESSION_KEY", (Object)captcha);
        this.httpSession.setAttribute("KAPTCHA_SESSION_DATE", (Object)new Date());
    }

    @Override
    public boolean match(String loginId, String captcha) {
        Assert.hasText((String)loginId, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        Assert.hasText((String)captcha, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        String kaptcha = (String)this.httpSession.getAttribute("KAPTCHA_SESSION_KEY");
        Date date = (Date)this.httpSession.getAttribute("KAPTCHA_SESSION_DATE");
        return date != null && LocalDateTimeHelper.of(date).toLocalDateTime().plus(this.kaptchaProperties.getExpireSeconds(), ChronoUnit.SECONDS).isAfter(LocalDateTimeHelper.now().toLocalDateTime()) && captcha.equalsIgnoreCase(kaptcha);
    }
}

