/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.support.excel.converter;

import cn.bestwu.simpleframework.support.MoneyUtil;
import cn.bestwu.simpleframework.support.excel.CellValueConverter;
import cn.bestwu.simpleframework.support.excel.ExcelFieldDescription;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.util.StringUtils;

public class YuanConverter
implements CellValueConverter {
    private static final YuanConverter instance = new YuanConverter();

    private YuanConverter() {
    }

    public static YuanConverter newInstance() {
        return instance;
    }

    @Override
    public String toCell(Object fieldValue, ExcelFieldDescription description, Object obj) {
        Long cent = (Long)fieldValue;
        return MoneyUtil.toYun(cent).toString();
    }

    @Override
    public Object fromCell(String cellValue, ExcelFieldDescription description, Object obj, Row row) {
        if (StringUtils.hasText((String)cellValue)) {
            return MoneyUtil.toCent(cellValue);
        }
        return null;
    }
}

