/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.support.excel;

import cn.bestwu.simpleframework.support.excel.AbstractExcelUtil;
import cn.bestwu.simpleframework.support.excel.CellStyleType;
import cn.bestwu.simpleframework.support.excel.CellValueConverter;
import cn.bestwu.simpleframework.support.excel.ExcelField;
import cn.bestwu.simpleframework.support.excel.ExcelFieldDescription;
import cn.bestwu.simpleframework.support.excel.FieldType;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ExcelExport
extends AbstractExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelExport.class);
    private List<ExcelFieldDescription> excelFieldDescriptions;
    private Workbook workbook;
    private Sheet sheet;
    private Map<String, CellStyle> styles;
    private int rownum;
    private Row row;
    private CellStyle defaultCellStyle;
    private int cellnum = 0;
    private boolean wrapText = false;
    private boolean includeComment = true;
    private DataFormat wbDataFormat;

    public ExcelExport(Class<?> cls) {
        this("\u5de5\u4f5c\u88681", cls, new int[0]);
    }

    public ExcelExport(int rowAccessWindowSize, Class<?> cls) {
        this(rowAccessWindowSize, "\u5de5\u4f5c\u88681", cls, new int[0]);
    }

    public ExcelExport(String sheetname, Class<?> cls, int ... groups) {
        this(500, sheetname, cls, groups);
    }

    public ExcelExport(Workbook workbook, Integer sheetIndex, Class<?> cls, int ... groups) {
        this.workbook = workbook;
        this.wbDataFormat = workbook.createDataFormat();
        this.sheet = workbook.getSheetAt(sheetIndex.intValue());
        this.rownum = 0;
        this.createStyles();
        this.initialize(cls, groups);
    }

    public ExcelExport(int rowAccessWindowSize, String sheetname, Class<?> cls, int ... groups) {
        this.workbook = new SXSSFWorkbook(rowAccessWindowSize);
        this.wbDataFormat = this.workbook.createDataFormat();
        this.initSheet(sheetname);
        this.initialize(cls, groups);
    }

    private ExcelExport initSheet(String sheetname) {
        this.sheet = this.workbook.createSheet(sheetname);
        this.rownum = 0;
        this.createStyles();
        return this;
    }

    public void includeComment() {
        this.includeComment = true;
    }

    public void excludeComment() {
        this.includeComment = false;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public ExcelExport wrapText(boolean wrapText) {
        this.wrapText = wrapText;
        return this;
    }

    public void setDefaultCellStyle(CellStyle defaultCellStyle) {
        this.defaultCellStyle = defaultCellStyle;
    }

    public ExcelExport initialize(Class<?> cls, int ... groups) {
        this.excelFieldDescriptions = this.getExcelFieldDescriptions(cls, FieldType.EXPORT, groups);
        return this;
    }

    public void createTitle(String title) {
        this.createTitle(title, this.getCellStyle(CellStyleType.TITLE));
    }

    public void createTitle(String title, CellStyle titleStyle) {
        Assert.hasText((String)title, (String)"title\u4e0d\u80fd\u4e3a\u7a7a");
        Row titleRow = this.sheet.createRow(this.rownum++);
        titleRow.setHeightInPoints(30.0f);
        Cell titleCell = titleRow.createCell(0);
        titleCell.setCellStyle(titleStyle);
        titleCell.setCellValue(title);
        this.sheet.addMergedRegion(new CellRangeAddress(titleRow.getRowNum(), titleRow.getRowNum(), 0, this.excelFieldDescriptions.size() - 1));
    }

    private void createHeader() {
        Row headerRow = this.sheet.createRow(this.rownum++);
        headerRow.setHeightInPoints(16.0f);
        for (int i = 0; i < this.excelFieldDescriptions.size(); ++i) {
            ExcelFieldDescription excelFieldDescription = this.excelFieldDescriptions.get(i);
            ExcelField excelField = excelFieldDescription.getExcelField();
            Cell cell = headerRow.createCell(i);
            String t = excelField.title();
            cell.setCellValue(t);
            cell.setCellStyle(this.getCellStyle(CellStyleType.HEADER));
            String commentStr = excelField.comment();
            if (this.includeComment && StringUtils.hasText((String)commentStr)) {
                Comment comment = this.sheet.createDrawingPatriarch().createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)i), this.rownum - 1, (int)((short)i), this.rownum - 1));
                comment.setString((RichTextString)new XSSFRichTextString(commentStr));
                cell.setCellComment(comment);
            }
            if (this.sheet instanceof SXSSFSheet) {
                ((SXSSFSheet)this.sheet).trackAllColumnsForAutoSizing();
            }
            this.sheet.autoSizeColumn(i);
            int colWidth = this.sheet.getColumnWidth(i) * 2;
            this.sheet.setColumnWidth(i, colWidth < 3000 ? 3000 : colWidth);
        }
    }

    public CellStyle getCellStyle(CellStyleType styleType) {
        HorizontalAlignment defaultAlignment = this.getDefaultAlign(styleType);
        return this.getCellStyle(styleType, defaultAlignment, true);
    }

    public CellStyle getCellStyle(CellStyleType styleType, HorizontalAlignment alignment) {
        return this.getCellStyle(styleType, alignment, true);
    }

    public CellStyle getCellStyle(CellStyleType styleType, HorizontalAlignment alignment, boolean border) {
        String styleName = this.styleName(styleType, alignment, border);
        CellStyle cellStyle = this.styles.get(styleName);
        if (cellStyle == null) {
            HorizontalAlignment defaultAlignment = this.getDefaultAlign(styleType);
            CellStyle defaultCellStyle = this.styles.get(this.styleName(styleType, defaultAlignment, border));
            cellStyle = this.workbook.createCellStyle();
            cellStyle.cloneStyleFrom(defaultCellStyle);
            cellStyle.setAlignment(alignment);
            this.styles.put(styleName, cellStyle);
        }
        return cellStyle;
    }

    @NotNull
    private HorizontalAlignment getDefaultAlign(CellStyleType styleType) {
        HorizontalAlignment defaultAlignment = null;
        switch (styleType) {
            case TITLE: {
                defaultAlignment = HorizontalAlignment.CENTER;
                break;
            }
            case HEADER: {
                defaultAlignment = HorizontalAlignment.CENTER;
                break;
            }
            case DATA: {
                defaultAlignment = HorizontalAlignment.GENERAL;
            }
        }
        return defaultAlignment;
    }

    private String styleName(CellStyleType styleType, HorizontalAlignment alignment, boolean border) {
        return styleType.name() + "-" + alignment.name() + "-" + (border ? "BORDER" : "NOBORDER");
    }

    private void createStyles() {
        this.styles = new HashMap<String, CellStyle>();
        CellStyle style = this.workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        Font titleFont = this.workbook.createFont();
        titleFont.setFontName("Arial");
        titleFont.setFontHeightInPoints((short)16);
        titleFont.setBold(true);
        style.setFont(titleFont);
        String styleName = this.styleName(CellStyleType.TITLE, HorizontalAlignment.CENTER, false);
        this.styles.put(styleName, style);
        style = this.createBorderCellStyle(styleName);
        this.styles.put(this.styleName(CellStyleType.TITLE, HorizontalAlignment.CENTER, true), style);
        style = this.workbook.createCellStyle();
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(this.wrapText);
        Font dataFont = this.workbook.createFont();
        dataFont.setFontName("Arial");
        dataFont.setFontHeightInPoints((short)10);
        style.setFont(dataFont);
        styleName = this.styleName(CellStyleType.DATA, HorizontalAlignment.GENERAL, false);
        this.styles.put(styleName, style);
        style = this.createBorderCellStyle(styleName);
        styleName = this.styleName(CellStyleType.DATA, HorizontalAlignment.GENERAL, true);
        this.styles.put(styleName, style);
        style = this.workbook.createCellStyle();
        style.cloneStyleFrom(this.styles.get(styleName));
        style.setAlignment(HorizontalAlignment.LEFT);
        this.styles.put(this.styleName(CellStyleType.DATA, HorizontalAlignment.LEFT, true), style);
        style = this.workbook.createCellStyle();
        style.cloneStyleFrom(this.styles.get(styleName));
        style.setAlignment(HorizontalAlignment.CENTER);
        this.styles.put(this.styleName(CellStyleType.DATA, HorizontalAlignment.CENTER, true), style);
        this.defaultCellStyle = style;
        style = this.workbook.createCellStyle();
        style.cloneStyleFrom(this.styles.get(styleName));
        style.setAlignment(HorizontalAlignment.RIGHT);
        this.styles.put(this.styleName(CellStyleType.DATA, HorizontalAlignment.RIGHT, true), style);
        style = this.workbook.createCellStyle();
        style.cloneStyleFrom(this.styles.get(this.styleName(CellStyleType.DATA, HorizontalAlignment.GENERAL, false)));
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Font headerFont = this.workbook.createFont();
        headerFont.setFontName("Arial");
        headerFont.setFontHeightInPoints((short)10);
        headerFont.setBold(true);
        headerFont.setColor(IndexedColors.WHITE.getIndex());
        style.setFont(headerFont);
        styleName = this.styleName(CellStyleType.HEADER, HorizontalAlignment.CENTER, false);
        this.styles.put(styleName, style);
        style = this.createBorderCellStyle(styleName);
        this.styles.put(this.styleName(CellStyleType.HEADER, HorizontalAlignment.CENTER, true), style);
    }

    @NotNull
    private CellStyle createBorderCellStyle(String styleName) {
        CellStyle style = this.workbook.createCellStyle();
        style.cloneStyleFrom(this.styles.get(styleName));
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        return style;
    }

    public void addMergedRegion(int firstCol, int lastCol) {
        int row = this.rownum - 1;
        this.addMergedRegion(row, row, firstCol, lastCol);
    }

    public void addMergedRegion(int firstRow, int lastRow, int firstCol, int lastCol) {
        this.sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
    }

    public void addValidationData(int firstCol, int lastCol, String[] explicitListValues) {
        int num = this.rownum - 1;
        this.addValidationData(num, num, firstCol, lastCol, explicitListValues);
    }

    public void addValidationData(int firstRow, int lastRow, int firstCol, int lastCol, String[] explicitListValues) {
        if (this.sheet instanceof XSSFSheet || this.sheet instanceof SXSSFSheet) {
            DataValidationHelper dvHelper = this.sheet.getDataValidationHelper();
            XSSFDataValidationConstraint dvConstraint = (XSSFDataValidationConstraint)dvHelper.createExplicitListConstraint(explicitListValues);
            CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
            XSSFDataValidation validation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
            validation.setSuppressDropDownArrow(true);
            validation.setShowErrorBox(true);
            this.sheet.addValidationData((DataValidation)validation);
        } else if (this.sheet instanceof HSSFSheet) {
            CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
            DVConstraint dvConstraint = DVConstraint.createExplicitListConstraint((String[])explicitListValues);
            HSSFDataValidation validation = new HSSFDataValidation(addressList, (DataValidationConstraint)dvConstraint);
            validation.setSuppressDropDownArrow(true);
            validation.setShowErrorBox(true);
            this.sheet.addValidationData((DataValidation)validation);
        }
    }

    public Cell addCell() {
        return this.addCell(this.cellnum);
    }

    public Cell addCell(CellStyle cellStyle) {
        return this.addCell(this.cellnum, cellStyle);
    }

    public Cell addCell(int column) {
        return this.addCell(column, this.defaultCellStyle);
    }

    public Cell addCell(int column, CellStyle cellStyle) {
        this.cellnum = column + 1;
        Cell cell = this.row.createCell(column);
        CellStyle style = this.workbook.createCellStyle();
        style.cloneStyleFrom(cellStyle);
        cell.setCellStyle(style);
        return cell;
    }

    public Row addRow() {
        this.row = this.sheet.getRow(this.rownum);
        if (this.row == null) {
            this.row = this.sheet.createRow(this.rownum++);
        }
        this.cellnum = 0;
        return this.row;
    }

    private Cell addCell(Row row, int column, Object val, ExcelField ef, ExcelFieldDescription excelFieldDescription, Object e) {
        HorizontalAlignment align = HorizontalAlignment.forInt((int)ef.align().ordinal());
        Class<? extends CellValueConverter> converter = ef.converter();
        Cell cell = row.createCell(column);
        String cellFormatString = ef.pattern();
        try {
            if (val == null) {
                cell.setCellValue("");
            } else if (converter != CellValueConverter.class) {
                CellValueConverter newInstance = this.getCellValueConverter(converter);
                cell.setCellValue(newInstance.toCell(val, excelFieldDescription, e));
            } else if (val instanceof String) {
                cell.setCellValue((String)val);
            } else if (val instanceof Integer) {
                cell.setCellValue((double)((Integer)val).intValue());
                cellFormatString = this.setCellFormatString(cellFormatString, "0");
            } else if (val instanceof Long) {
                cell.setCellValue((double)((Long)val).longValue());
                cellFormatString = this.setCellFormatString(cellFormatString, "0");
            } else if (val instanceof BigDecimal) {
                cell.setCellValue(((BigDecimal)val).toPlainString());
                cellFormatString = this.setCellFormatString(cellFormatString, "0.00");
            } else if (val instanceof Double) {
                cell.setCellValue(((Double)val).doubleValue());
                cellFormatString = this.setCellFormatString(cellFormatString, "0.00");
            } else if (val instanceof Float) {
                cell.setCellValue((double)((Float)val).floatValue());
                cellFormatString = this.setCellFormatString(cellFormatString, "0.00");
            } else if (val instanceof Date) {
                cell.setCellValue((Date)val);
                cellFormatString = this.setCellFormatString(cellFormatString, "yyyy-MM-dd HH:mm");
            } else {
                log.warn("Can not set cell value [" + val + "]");
                cell.setCellValue("");
            }
        }
        catch (Exception ex) {
            log.warn("Set cell value [" + row.getRowNum() + "," + column + "] error: " + ex.toString());
            cell.setCellValue(val.toString());
        }
        CellStyle style = this.styles.get("data_column_" + column);
        if (style == null) {
            style = this.workbook.createCellStyle();
            style.cloneStyleFrom(this.getCellStyle(CellStyleType.DATA, align));
            cellFormatString = this.setCellFormatString(cellFormatString, "@");
            style.setDataFormat(this.getFormat(cellFormatString));
            this.styles.put("data_column_" + column, style);
        }
        cell.setCellStyle(style);
        return cell;
    }

    public short getFormat(String cellFormatString) {
        return this.wbDataFormat.getFormat(cellFormatString);
    }

    @NotNull
    private String setCellFormatString(String cellFormatString, String format) {
        if (!StringUtils.hasText((String)cellFormatString)) {
            return format;
        }
        return cellFormatString;
    }

    private Object invokeGetter(Object obj, String propertyName) throws NoSuchMethodException {
        Object object = obj;
        for (String name : StringUtils.split((String)propertyName, (String)".")) {
            String getterMethodName = "get" + StringUtils.capitalize((String)name);
            object = ReflectionUtils.invokeMethod((Method)object.getClass().getMethod(getterMethodName, new Class[0]), (Object)object);
        }
        return object;
    }

    public <E> ExcelExport setDataList(List<E> list) {
        return this.setDataList(0, list);
    }

    public <E> ExcelExport setDataList(int startColunm, List<E> list) {
        this.createHeader();
        for (E e : list) {
            int colunm = startColunm;
            Row row = this.addRow();
            StringBuilder sb = new StringBuilder();
            for (ExcelFieldDescription fieldDescription : this.excelFieldDescriptions) {
                ExcelField excelField = fieldDescription.getExcelField();
                Object val = null;
                try {
                    if (StringUtils.hasText((String)excelField.value())) {
                        val = this.invokeGetter(e, excelField.value());
                    } else {
                        AccessibleObject accessibleObject = fieldDescription.getAccessibleObject();
                        if (accessibleObject instanceof Field) {
                            String propertyName = ((Field)accessibleObject).getName();
                            val = ReflectionUtils.invokeMethod((Method)BeanUtils.getPropertyDescriptor(e.getClass(), (String)propertyName).getReadMethod(), e);
                        } else if (accessibleObject instanceof Method) {
                            String methodName = ((Method)accessibleObject).getName();
                            val = ReflectionUtils.invokeMethod((Method)e.getClass().getMethod(methodName, new Class[0]), e);
                        }
                    }
                }
                catch (Exception ex) {
                    log.info(ex.toString());
                    val = "";
                }
                this.addCell(row, colunm++, val, excelField, fieldDescription, e);
                sb.append(val).append(", ");
            }
            log.debug("Write success: [" + row.getRowNum() + "] " + sb.toString());
        }
        return this;
    }

    public ExcelExport write(OutputStream os) throws IOException {
        this.workbook.write(os);
        this.dispose();
        return this;
    }

    public ExcelExport write(HttpServletRequest request, HttpServletResponse response, String fileName) throws IOException {
        response.reset();
        String agent = request.getHeader("USER-AGENT");
        String newFileName = null != agent && (agent.contains("Trident") || agent.contains("Edge")) ? URLEncoder.encode(fileName, "UTF-8") : MimeUtility.encodeText((String)fileName, (String)"UTF8", (String)"B");
        response.setHeader("Content-Disposition", "attachment;filename=" + newFileName + this.getExtension() + ";filename*=UTF-8''" + URLEncoder.encode(fileName, "UTF-8") + this.getExtension());
        response.setContentType("application/vnd.ms-excel; charset=utf-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        this.write((OutputStream)response.getOutputStream());
        return this;
    }

    @NotNull
    public String getExtension() {
        if (this.workbook instanceof XSSFWorkbook || this.workbook instanceof SXSSFWorkbook) {
            return ".xlsx";
        }
        return ".xls";
    }

    public ExcelExport writeFile(String fileName) throws IOException {
        FileOutputStream os = new FileOutputStream(fileName);
        this.write(os);
        return this;
    }

    public ExcelExport dispose() throws IOException {
        this.workbook.close();
        if (this.workbook instanceof SXSSFWorkbook) {
            ((SXSSFWorkbook)this.workbook).dispose();
        }
        return this;
    }
}

