/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.support;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;

public class LocalDateTimeHelper {
    public static final ZoneOffset DEFAULT_ZONE_OFFSET = ZoneOffset.of("+8");
    private final LocalDateTime localDateTime;
    private ZoneOffset zoneOffset;

    private LocalDateTimeHelper(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        this.localDateTime = localDateTime;
        this.zoneOffset = zoneOffset;
    }

    public static LocalDateTimeHelper now() {
        return new LocalDateTimeHelper(LocalDateTime.now(), DEFAULT_ZONE_OFFSET);
    }

    public static LocalDateTimeHelper parse(CharSequence text) {
        return new LocalDateTimeHelper(LocalDateTime.parse(text), DEFAULT_ZONE_OFFSET);
    }

    public static LocalDateTimeHelper parse(CharSequence text, DateTimeFormatter formatter) {
        return new LocalDateTimeHelper(LocalDateTime.parse(text, formatter), DEFAULT_ZONE_OFFSET);
    }

    public static LocalDateTimeHelper of(int year, int month, int dayOfMonth) {
        return new LocalDateTimeHelper(LocalDate.of(year, month, dayOfMonth).atStartOfDay(), DEFAULT_ZONE_OFFSET);
    }

    public static LocalDateTimeHelper of(LocalDateTime localDateTime) {
        return new LocalDateTimeHelper(localDateTime, DEFAULT_ZONE_OFFSET);
    }

    public static LocalDateTimeHelper of(LocalDate localDate) {
        return new LocalDateTimeHelper(localDate.atStartOfDay(), DEFAULT_ZONE_OFFSET);
    }

    public static LocalDateTimeHelper of(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return LocalDateTimeHelper.of(calendar);
    }

    public static LocalDateTimeHelper of(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return LocalDateTimeHelper.of(calendar);
    }

    public static LocalDateTimeHelper of(Calendar calendar) {
        return new LocalDateTimeHelper(LocalDateTime.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000000), DEFAULT_ZONE_OFFSET);
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(DEFAULT_ZONE_OFFSET).toInstant());
    }

    public long toMillis() {
        return this.toInstant().toEpochMilli();
    }

    public Date toDate() {
        return Date.from(this.toInstant());
    }

    public Instant toInstant() {
        return this.toLocalDateTime().toInstant(this.zoneOffset);
    }

    public LocalDateTime toLocalDateTime() {
        return this.localDateTime;
    }

    public LocalDate toLocalDate() {
        return this.localDateTime.toLocalDate();
    }

    public String format() {
        return this.toLocalDateTime().format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        return this.localDateTime.format(dateTimeFormatter);
    }

    public LocalDateTimeHelper zoneOffset(ZoneOffset zoneOffset) {
        this.zoneOffset = zoneOffset;
        return this;
    }

    public LocalDateTimeHelper getFirstDayOfMonth() {
        return LocalDateTimeHelper.of(this.localDateTime.with(TemporalAdjusters.firstDayOfMonth())).zoneOffset(this.zoneOffset);
    }

    public LocalDateTimeHelper getFirstDayOfNextMonth() {
        return LocalDateTimeHelper.of(this.localDateTime.with(TemporalAdjusters.firstDayOfNextMonth())).zoneOffset(this.zoneOffset);
    }

    public LocalDateTimeHelper getLastDayOfMonth() {
        return LocalDateTimeHelper.of(this.localDateTime.with(TemporalAdjusters.lastDayOfMonth())).zoneOffset(this.zoneOffset);
    }

    public LocalDateTimeHelper getFirstDayOfQuarter() {
        return LocalDateTimeHelper.of(this.localDateTime.withMonth(this.localDateTime.getMonth().firstMonthOfQuarter().getValue()).with(TemporalAdjusters.firstDayOfMonth())).zoneOffset(this.zoneOffset);
    }

    public LocalDateTimeHelper getFirstDayOfNextQuarter() {
        return LocalDateTimeHelper.of(this.localDateTime.withMonth(this.localDateTime.getMonth().firstMonthOfQuarter().plus(3L).getValue()).with(TemporalAdjusters.firstDayOfMonth())).zoneOffset(this.zoneOffset);
    }

    public LocalDateTimeHelper getLastDayOfQuarter() {
        return LocalDateTimeHelper.of(this.localDateTime.withMonth(this.localDateTime.getMonth().firstMonthOfQuarter().plus(2L).getValue()).with(TemporalAdjusters.lastDayOfMonth())).zoneOffset(this.zoneOffset);
    }

    public LocalDateTimeHelper getFirstDayOfYear() {
        return LocalDateTimeHelper.of(this.localDateTime.with(TemporalAdjusters.firstDayOfYear())).zoneOffset(this.zoneOffset);
    }

    public LocalDateTimeHelper getFirstDayOfNextYear() {
        return LocalDateTimeHelper.of(this.localDateTime.with(TemporalAdjusters.firstDayOfNextYear())).zoneOffset(this.zoneOffset);
    }

    public LocalDateTimeHelper getLastDayOfYear() {
        return LocalDateTimeHelper.of(this.localDateTime.with(TemporalAdjusters.lastDayOfYear())).zoneOffset(this.zoneOffset);
    }
}

