/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.config;

import java.time.Duration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.context.MessageSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.context.MessageSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnMissingBean(value={MessageSource.class}, search=SearchStrategy.CURRENT)
@AutoConfigureOrder(value=-2147483648)
@AutoConfigureBefore(value={MessageSourceAutoConfiguration.class})
@EnableConfigurationProperties
@Conditional(value={ResourceBundleCondition.class})
public class MessageSourceConfiguration {
    public static final String BASE_MESSAGES = "base-messages";
    public static final String CORE_MESSAGES = "core-messages";
    private static final Resource[] NO_RESOURCES = new Resource[0];

    @Bean
    @ConfigurationProperties(prefix="spring.messages")
    public MessageSourceProperties messageSourceProperties() {
        return new MessageSourceProperties();
    }

    @Bean
    public MessageSource messageSource(ApplicationContext applicationContext, MessageSourceProperties messageSourceProperties) {
        Resource[] resources;
        boolean noCore;
        String basename = messageSourceProperties.getBasename();
        if (!basename.contains(BASE_MESSAGES)) {
            basename = basename + "," + BASE_MESSAGES;
        }
        boolean bl = noCore = !basename.contains(CORE_MESSAGES);
        if (noCore && (resources = ResourceBundleCondition.getResources(applicationContext.getClassLoader(), CORE_MESSAGES)).length > 0 && resources[0].exists()) {
            basename = basename + "," + CORE_MESSAGES;
        }
        messageSourceProperties.setBasename(basename);
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        if (StringUtils.hasText((String)messageSourceProperties.getBasename())) {
            messageSource.setBasenames(StringUtils.commaDelimitedListToStringArray((String)StringUtils.trimAllWhitespace((String)messageSourceProperties.getBasename())));
        }
        if (messageSourceProperties.getEncoding() != null) {
            messageSource.setDefaultEncoding(messageSourceProperties.getEncoding().name());
        }
        messageSource.setFallbackToSystemLocale(messageSourceProperties.isFallbackToSystemLocale());
        Duration cacheDuration = messageSourceProperties.getCacheDuration();
        if (cacheDuration != null) {
            messageSource.setCacheMillis(cacheDuration.toMillis());
        }
        messageSource.setAlwaysUseMessageFormat(messageSourceProperties.isAlwaysUseMessageFormat());
        messageSource.setUseCodeAsDefaultMessage(messageSourceProperties.isUseCodeAsDefaultMessage());
        return messageSource;
    }

    protected static class ResourceBundleCondition
    extends SpringBootCondition {
        private static ConcurrentReferenceHashMap<String, ConditionOutcome> cache = new ConcurrentReferenceHashMap();

        protected ResourceBundleCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String basename = context.getEnvironment().getProperty("spring.messages.basename", "messages");
            ConditionOutcome outcome = (ConditionOutcome)cache.get((Object)basename);
            if (outcome == null) {
                outcome = this.getMatchOutcomeForBasename(context, basename);
                cache.put((Object)basename, (Object)outcome);
            }
            return outcome;
        }

        private ConditionOutcome getMatchOutcomeForBasename(ConditionContext context, String basename) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"ResourceBundle", (Object[])new Object[0]);
            for (String name : StringUtils.commaDelimitedListToStringArray((String)StringUtils.trimAllWhitespace((String)basename))) {
                for (Resource resource : ResourceBundleCondition.getResources(context.getClassLoader(), name)) {
                    if (!resource.exists()) continue;
                    return ConditionOutcome.match((ConditionMessage)message.found("bundle").items(new Object[]{resource}));
                }
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("bundle with basename " + basename).atAll());
        }

        private static Resource[] getResources(ClassLoader classLoader, String name) {
            String target = name.replace('.', '/');
            try {
                return new PathMatchingResourcePatternResolver(classLoader).getResources("classpath*:" + target + ".properties");
            }
            catch (Exception ex) {
                return NO_RESOURCES;
            }
        }
    }
}

