/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.config;

import cn.bestwu.logging.annotation.NoRequestLogging;
import cn.bestwu.simpleframework.support.packagescan.PackageScanClassResolver;
import cn.bestwu.simpleframework.web.CustomErrorController;
import cn.bestwu.simpleframework.web.DataErrorHandler;
import cn.bestwu.simpleframework.web.DefaultCaptchaServiceImpl;
import cn.bestwu.simpleframework.web.ErrorAttributes;
import cn.bestwu.simpleframework.web.ICaptchaService;
import cn.bestwu.simpleframework.web.IErrorHandler;
import cn.bestwu.simpleframework.web.filter.OrderedHiddenHttpMethodFilter;
import cn.bestwu.simpleframework.web.filter.OrderedHttpPutFormContentFilter;
import cn.bestwu.simpleframework.web.kaptcha.KaptchaProperties;
import cn.bestwu.simpleframework.web.resolver.StringToEnumConverterFactory;
import cn.bestwu.simpleframework.web.serializer.BigDecimalSerializer;
import cn.bestwu.simpleframework.web.serializer.MixIn;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.code.kaptcha.Producer;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.CustomRequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration
@ConditionalOnWebApplication
@AutoConfigureBefore(value={ErrorMvcAutoConfiguration.class, JacksonAutoConfiguration.class})
public class FrameworkMvcConfiguration {
    private final Logger log = LoggerFactory.getLogger(FrameworkMvcConfiguration.class);
    @Value(value="${app.jackson.mix-in-annotation.base-packages:}")
    private String[] basePackages;
    @Value(value="${app.web.ok.enable:false}")
    private Boolean okEnable;

    @Bean(name={"error"})
    @ConditionalOnMissingBean(name={"error"})
    public View error(final ObjectMapper objectMapper, final @Value(value="${app.web.ok.enable:false}") Boolean okEnable) {
        return new View(){

            public String getContentType() {
                return "text/html;charset=utf-8";
            }

            public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
                if (response.getContentType() == null) {
                    response.setContentType(this.getContentType());
                }
                String result = objectMapper.writeValueAsString(model);
                if (okEnable.booleanValue()) {
                    response.setStatus(HttpStatus.OK.value());
                }
                response.getWriter().append(result);
            }
        };
    }

    @Bean
    public Module module(ApplicationContext applicationContext, PackageScanClassResolver packageScanClassResolver) {
        SimpleModule module = new SimpleModule();
        Set<String> packages = PackageScanClassResolver.detectPackagesToScan(applicationContext, this.basePackages);
        packages.add("cn.bestwu.simpleframework.data.serializer");
        Set<Class<?>> allSubClasses = packageScanClassResolver.findImplementations(MixIn.class, packages.toArray(new String[0]));
        for (Class<?> aClass : allSubClasses) {
            try {
                ParameterizedType object = (ParameterizedType)aClass.getGenericInterfaces()[0];
                Class targetType = (Class)object.getActualTypeArguments()[0];
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Detected MixInAnnotation:{}=>{}", (Object)targetType, aClass);
                }
                module.setMixInAnnotation(targetType, aClass);
            }
            catch (Exception e) {
                this.log.warn(aClass + "Detected fail", (Throwable)e);
            }
        }
        return module;
    }

    @Bean
    public OrderedHiddenHttpMethodFilter hiddenHttpMethodFilter() {
        return new OrderedHiddenHttpMethodFilter();
    }

    @Bean
    public OrderedHttpPutFormContentFilter putFormContentFilter() {
        return new OrderedHttpPutFormContentFilter();
    }

    @ConditionalOnMissingBean(value={ErrorAttributes.class})
    @Bean
    public ErrorAttributes errorAttributes(@Autowired(required=false) List<IErrorHandler> errorHandlers) {
        return new ErrorAttributes(errorHandlers);
    }

    @ConditionalOnMissingBean(value={ErrorController.class})
    @Bean
    public CustomErrorController customErrorController(ErrorAttributes errorAttributes, ServerProperties serverProperties, @Autowired(required=false) @Qualifier(value="corsConfigurationSource") CorsConfigurationSource configSource) {
        return new CustomErrorController((org.springframework.boot.web.servlet.error.ErrorAttributes)errorAttributes, serverProperties.getError(), configSource, this.okEnable);
    }

    @Conditional(value={CustomRequestMappingConditio.class})
    @Bean
    public WebMvcRegistrations webMvcRegistrations(final @Value(value="${app.web.ok.enable:false}") Boolean okEnable, final @Value(value="${app.web.wrap.enable:false}") Boolean wrapEnable) {
        return new WebMvcRegistrations(){

            public RequestMappingHandlerAdapter getRequestMappingHandlerAdapter() {
                return new CustomRequestMappingHandlerAdapter(okEnable, wrapEnable);
            }
        };
    }

    @Configuration
    @ConditionalOnWebApplication
    protected static class WebMvcConfiguration
    implements WebMvcConfigurer {
        protected WebMvcConfiguration() {
        }

        public void addFormatters(FormatterRegistry registry) {
            registry.addConverterFactory((ConverterFactory)new StringToEnumConverterFactory());
            registry.addConverter((Converter)new Converter<String, java.util.Date>(){

                public java.util.Date convert(String source) {
                    if (StringUtils.hasLength((String)source) && !"null".equals(source)) {
                        return new java.util.Date(Long.parseLong(source));
                    }
                    return null;
                }
            });
            registry.addConverter((Converter)new Converter<String, Date>(){

                public Date convert(String source) {
                    if (StringUtils.hasLength((String)source) && !"null".equals(source)) {
                        return new Date(Long.parseLong(source));
                    }
                    return null;
                }
            });
        }
    }

    public static class CustomRequestMappingConditio
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return "true".equals(context.getEnvironment().getProperty("app.web.wrap.enable")) || "true".equals(context.getEnvironment().getProperty("app.web.ok.enable"));
        }
    }

    @Configuration
    @ConditionalOnClass(value={DefaultKaptcha.class})
    @ConditionalOnWebApplication
    @EnableConfigurationProperties(value={KaptchaProperties.class})
    protected static class KaptchaConfiguration {
        protected KaptchaConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Producer.class})
        public DefaultKaptcha kaptcha(KaptchaProperties kaptchaProperties) {
            Properties properties = new Properties();
            properties.put("kaptcha.border", kaptchaProperties.getBorder());
            properties.put("kaptcha.textproducer.font.color", kaptchaProperties.getTextproducerFontColor());
            properties.put("kaptcha.textproducer.char.space", (Object)kaptchaProperties.getTextproducerCharSpace());
            Config config = new Config(properties);
            DefaultKaptcha defaultKaptcha = new DefaultKaptcha();
            defaultKaptcha.setConfig(config);
            return defaultKaptcha;
        }

        @Bean
        @ConditionalOnMissingBean(value={ICaptchaService.class})
        public ICaptchaService captchaService(@Autowired(required=false) HttpSession httpSession, KaptchaProperties kaptchaProperties) {
            return new DefaultCaptchaServiceImpl(httpSession, kaptchaProperties);
        }

        @Controller
        protected static class CaptchaController {
            private Logger log = LoggerFactory.getLogger(CaptchaController.class);
            private final Producer producer;
            private final ICaptchaService captchaService;

            public CaptchaController(Producer producer, ICaptchaService captchaService) {
                this.producer = producer;
                this.captchaService = captchaService;
            }

            @NoRequestLogging
            @GetMapping(value={"/captcha.jpg"}, name="\u56fe\u7247\u9a8c\u8bc1\u7801")
            public void captcha(HttpServletRequest request, HttpServletResponse response, String loginId) throws IOException {
                String text = this.producer.createText();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("\u9a8c\u8bc1\u7801\uff1a{}", (Object)text);
                }
                BufferedImage image = this.producer.createImage(text);
                if (!StringUtils.hasText((String)loginId)) {
                    loginId = request.getRequestedSessionId();
                }
                this.captchaService.save(loginId, text);
                response.setContentType("image/jpeg");
                response.addHeader("loginId", loginId);
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setDateHeader("Expires", 0L);
                ServletOutputStream out = response.getOutputStream();
                ImageIO.write((RenderedImage)image, "jpg", (OutputStream)out);
            }
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    protected static class ObjectMapperBuilderCustomizer
    implements Jackson2ObjectMapperBuilderCustomizer {
        protected ObjectMapperBuilderCustomizer() {
        }

        public void customize(Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder) {
            jacksonObjectMapperBuilder.serializerByType(BigDecimal.class, (JsonSerializer)new BigDecimalSerializer());
        }
    }

    @Configuration
    @ConditionalOnClass(value={EmptyResultDataAccessException.class})
    @ConditionalOnWebApplication
    protected static class ErrorHandlerConfiguration {
        protected ErrorHandlerConfiguration() {
        }

        @Bean
        public DataErrorHandler dataErrorHandler() {
            return new DataErrorHandler();
        }
    }
}

