package cn.bestwu.simpleframework.web.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.StringUtils;

/**
 * @author Peter Wu
 */
public class NullDefaultSerializer extends StdSerializer<Object> {

  private static final long serialVersionUID = 1L;
  private final Class<?> type;
  private final String defaultValue;
  private static final ConversionService CONVERSION_SERVICE = new DefaultConversionService();

  public NullDefaultSerializer(Class<?> type, String defaultValue) {
    super(Object.class);
    this.type = type;
    this.defaultValue = defaultValue;
  }

  @Override
  public void serialize(Object value, JsonGenerator gen, SerializerProvider provider)
      throws IOException {
    if (StringUtils.hasText(defaultValue)) {
      gen.writeObject(CONVERSION_SERVICE.convert(defaultValue, type));
    } else {
      serializeNull(gen, type, value);
    }
  }

  public static void serializeNull(JsonGenerator gen, Class<?> type, Object value)
      throws IOException {
    if (type == String.class) {
      gen.writeString("");
    } else if (type.isArray() || (Collection.class.isAssignableFrom(type) && !Map.class
        .isAssignableFrom(type))) {
      gen.writeObject(Collections.EMPTY_LIST);
    } else if (type.getClassLoader() != null || Map.class.isAssignableFrom(type)) {
      gen.writeObject(Collections.emptyMap());
    } else {
      gen.writeObject(value);
    }
  }

  public static boolean support(Class<?> type) {
    return (type == String.class) || (type.isArray() || (Collection.class.isAssignableFrom(type)
        && !Map.class
        .isAssignableFrom(type))) || (type.getClassLoader() != null || Map.class
        .isAssignableFrom(type));
  }

  @Override
  public final void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider,
      TypeSerializer typeSer) throws IOException {
    serialize(value, gen, provider);
  }
}
