package cn.bestwu.simpleframework.web.serializer;

import cn.bestwu.simpleframework.web.serializer.annotation.JsonDefault;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.util.List;

public class CustomNullSerializerModifier extends BeanSerializerModifier {

  /**
   * 无注释{@code cn.bestwu.simpleframework.web.serializer.annotation.JsonDefault}时是否使用默认序列化
   */
  private boolean useDefault;

  public CustomNullSerializerModifier(boolean useDefault) {
    this.useDefault = useDefault;
  }

  @Override
  public List<BeanPropertyWriter> changeProperties(SerializationConfig config,
      BeanDescription beanDesc,
      List<BeanPropertyWriter> beanProperties) {
    for (BeanPropertyWriter writer : beanProperties) {
      if (!writer.hasNullSerializer()) {
        Class<?> rawClass = writer.getType().getRawClass();
        JsonDefault annotation = writer.getAnnotation(JsonDefault.class);
        String value = "";
        if (annotation != null) {
          value = annotation.value();
        }
        if ((useDefault && NullDefaultSerializer.support(rawClass)) || annotation != null) {
          writer.assignNullSerializer(new NullDefaultSerializer(rawClass, value));
        }
      }
    }
    return beanProperties;
  }

}