package cn.bestwu.simpleframework.web.resolver;

import cn.bestwu.simpleframework.web.RespEntity;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.HttpEntityMethodProcessor;

/**
 * @author Peter Wu
 */
public class WrapperHttpEntityMethodProcessor extends HttpEntityMethodProcessor {

  private final Boolean okEnable;
  private final Boolean wrapEnable;

  public WrapperHttpEntityMethodProcessor(
      List<HttpMessageConverter<?>> converters,
      ContentNegotiationManager manager, List<Object> requestResponseBodyAdvice,
      Boolean okEnable, Boolean wrapEnable) {
    super(converters, manager, requestResponseBodyAdvice);
    this.okEnable = okEnable;
    this.wrapEnable = wrapEnable;
  }

  @Override
  public void handleReturnValue(Object returnValue, MethodParameter returnType,
      ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
    HttpEntity<?> responseEntity = (HttpEntity<?>) returnValue;

    if (responseEntity instanceof ResponseEntity) {
      int statusCode = ((ResponseEntity<?>) responseEntity).getStatusCode().value();
      if (okEnable && statusCode != 404 && statusCode != 405) {
        returnValue = ResponseEntity.ok().headers(responseEntity.getHeaders())
            .body(responseEntity.getBody());
      }
    }
    super.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
  }

  @Override
  protected <T> void writeWithMessageConverters(T value, MethodParameter returnType,
      ServletServerHttpRequest inputMessage, ServletServerHttpResponse outputMessage)
      throws IOException, HttpMediaTypeNotAcceptableException, HttpMessageNotWritableException {
    Object val = value;
    if (wrapEnable) {
      if (value != null && !value.getClass().equals(RespEntity.class)) {
        if (value instanceof Exception) {
          val = new RespEntity(String.valueOf(HttpStatus.BAD_REQUEST.value()),
              ((Exception) value).getMessage());
        } else {
          val = new RespEntity(value);
        }
      } else if (val == null) {
        val = new RespEntity(Collections.emptyMap());
      }
    }
    super.writeWithMessageConverters(val, returnType, inputMessage, outputMessage);
  }
}
