package cn.bestwu.simpleframework.support.excel.converter;

import cn.bestwu.simpleframework.support.excel.CellValueConverter;
import cn.bestwu.simpleframework.support.excel.ExcelField;
import cn.bestwu.simpleframework.support.excel.ExcelFieldDescription;
import java.time.format.DateTimeFormatter;
import org.springframework.util.StringUtils;

public abstract class AbstractDateConverter implements CellValueConverter {

  protected DateTimeFormatter getDateTimeFormatter(ExcelFieldDescription description) {
    ExcelField excelField = description.getExcelField();
    String pattern = excelField.pattern();
    if ("".equals(pattern)) {
      pattern = excelField.converterUsing();
    }
    DateTimeFormatter dateTimeFormatter;
    if (StringUtils.hasText(pattern)) {
      dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
    } else {
      dateTimeFormatter = DateTimeFormatter.ISO_DATE;
    }
    return dateTimeFormatter;
  }

}