package cn.bestwu.simpleframework.support.excel;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/**
 * @author Peter Wu
 * @since 0.0.1
 */
public abstract class AbstractExcelUtil {

  protected CellValueConverter getCellValueConverter(Class<? extends CellValueConverter> converter)
      throws InstantiationException, IllegalAccessException {
    CellValueConverter newInstance;
    try {
      newInstance = (CellValueConverter) converter.getMethod("newInstance").invoke(null);
    } catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | SecurityException | NoSuchMethodException e1) {
      newInstance = converter.newInstance();
    }
    return newInstance;
  }

  @NotNull
  public List<ExcelFieldDescription> getExcelFieldDescriptions(Class<?> cls, FieldType type,
      int... groups) {
    List<ExcelFieldDescription> fieldDescriptions = new ArrayList<>();
    // Get annotation field
    Field[] fields = cls.getDeclaredFields();
    for (Field f : fields) {
      readExcelField(fieldDescriptions, f, type, groups);
    }
    // Get annotation method
    Method[] methods = cls.getMethods();
    for (Method method : methods) {
      readExcelField(fieldDescriptions, method, type, groups);
    }
    // Field sorting
    fieldDescriptions.sort(Comparator.comparingInt(o -> (o.getExcelField()).sort()));
    return fieldDescriptions;
  }

  private void readExcelField(List<ExcelFieldDescription> fieldDescriptions,
      AccessibleObject accessibleObject, FieldType type, int... groups) {
    ExcelField excelField = accessibleObject.getAnnotation(ExcelField.class);
    if (excelField != null && (excelField.type().equals(FieldType.ALL) || excelField.type()
        .equals(type))) {
      if (groups != null && groups.length > 0) {
        boolean inGroup = false;
        for (int group : groups) {
          if (inGroup) {
            break;
          }
          for (int efg : excelField.groups()) {
            if (group == efg) {
              inGroup = true;
              fieldDescriptions.add(new ExcelFieldDescription(excelField, accessibleObject));
              break;
            }
          }
        }
      } else {
        fieldDescriptions.add(new ExcelFieldDescription(excelField, accessibleObject));
      }
    }
  }
}
