package cn.bestwu.simpleframework.support;

import java.math.BigDecimal;

/**
 * 金额相关计算工具类
 *
 * @author Peter Wu
 */
public class MoneyUtil {

  /**
   * @param yuan 单位元
   * @return 单位分
   */
  public static Long toCent(String yuan) {
    return new BigDecimal(yuan).setScale(2, BigDecimal.ROUND_HALF_UP)
        .multiply(new BigDecimal(100)).longValue();
  }

  /**
   * @param cent 单位分
   * @return 单位元
   */
  public static BigDecimal toYun(long cent) {
    return toYun(new BigDecimal(cent), 2);
  }

  /**
   * @param cent 单位分
   * @param scale 小数位数
   * @return 单位元
   */
  public static BigDecimal toYun(BigDecimal cent, int scale) {
    return cent.divide(new BigDecimal(100), scale, BigDecimal.ROUND_HALF_UP);
  }
}
