package cn.bestwu.simpleframework.exception;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * @author Peter Wu
 */
@ResponseStatus(HttpStatus.BAD_REQUEST)
public class BusinessException extends RuntimeException {

  private static final long serialVersionUID = -7941819415782111951L;
  /**
   * 业务错误码
   */
  private final String code;
  private final Object data;
  private static ResourceBundle bundle;

  static {
    try {
      bundle = ResourceBundle.getBundle("errorCode");
    } catch (MissingResourceException e) {
      try {
        bundle = ResourceBundle.getBundle("properties.errorCode");
      } catch (MissingResourceException ignored) {
      }
    }
  }

  public BusinessException(String code) {
    super(bundle != null && bundle.containsKey(code) ? bundle.getString(code) : code);
    this.code = code;
    this.data = null;
  }

  public BusinessException(String code, Object data) {
    super(bundle != null && bundle.containsKey(code) ? bundle.getString(code) : code);
    this.code = code;
    this.data = data;
  }

  public BusinessException(String code, String message) {
    super(message);
    this.code = code;
    this.data = null;
  }

  public BusinessException(String code, String message, Object data) {
    super(message);
    this.code = code;
    this.data = data;
  }

  public String getCode() {
    return code;
  }

  public Object getData() {
    return data;
  }
}
