package cn.bestwu.simpleframework.web.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.ClassUtils;

/**
 * @author Peter Wu
 */
public class NullAsEmptySerializer extends StdSerializer<Object> {

  private static final long serialVersionUID = 1L;
  private static final Map<Class<?>, Object> PRIMITIVE_DEFAULT_VALUE = new HashMap<>();
  private final Class<?> type;

  static {
    PRIMITIVE_DEFAULT_VALUE.put(Boolean.class, false);
    PRIMITIVE_DEFAULT_VALUE.put(Character.class, 0);
    PRIMITIVE_DEFAULT_VALUE.put(Byte.class, 0);
    PRIMITIVE_DEFAULT_VALUE.put(Short.class, 0);
    PRIMITIVE_DEFAULT_VALUE.put(Integer.class, 0);
    PRIMITIVE_DEFAULT_VALUE.put(Long.class, 0);
    PRIMITIVE_DEFAULT_VALUE.put(Float.class, 0.0);
    PRIMITIVE_DEFAULT_VALUE.put(Double.class, 0.0);
  }

  public NullAsEmptySerializer() {
    this(Object.class);
  }

  public NullAsEmptySerializer(Class<?> type) {
    super(Object.class);
    this.type = type;
  }

  @Override
  public void serialize(Object value, JsonGenerator gen, SerializerProvider provider)
      throws IOException {
    if (type == Date.class) {
      gen.writeObject(new Date(0));
    } else if (type == BigDecimal.class) {
      gen.writeObject(0.0);
    } else if (ClassUtils.isPrimitiveWrapper(type)) {
      gen.writeObject(PRIMITIVE_DEFAULT_VALUE.get(type));
    } else {
      serializeNull(gen, type, value);
    }
  }

  public static void serializeNull(JsonGenerator gen, Class<?> type, Object value)
      throws IOException {
    if (type == String.class) {
      gen.writeString("");
    } else if (type.isArray() || (Collection.class.isAssignableFrom(type) && !Map.class
        .isAssignableFrom(type))) {
      gen.writeObject(Collections.EMPTY_LIST);
    } else if (type.getClassLoader() != null || Map.class.isAssignableFrom(type)) {
      gen.writeObject(Collections.emptyMap());
    } else {
      gen.writeObject(value);
    }
  }
}
