package cn.bestwu.simpleframework.web;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;

/**
 * @author Peter Wu
 */
public class RespEntity extends HashMap<String, Object> {

  private static final long serialVersionUID = 8147627015022481894L;
  public static final String KEY_STATUS = "status";
  public static final String KEY_MESSAGE = "message";
  public static final String KEY_DATA = "data";
  public static final String KEY_TRACE = "trace";
  private HttpStatus httpStatus;
  private Map<String, String> errors = new LinkedHashMap<>();

  public RespEntity() {
  }

  public RespEntity(String status) {
    this(status, new HashMap<>());
  }

  public RespEntity(Object data) {
    this(String.valueOf(HttpStatus.OK.value()), "", data);
  }

  public RespEntity(String status, String message) {
    this(status, message, new HashMap<>());
  }

  public RespEntity(String status, Object data) {
    this(status, "", data);
  }

  public RespEntity(String status, String message, Object data) {
    setStatus(status);
    setMessage(message);
    setData(data);
  }

  public HttpStatus getHttpStatus() {
    return httpStatus;
  }

  public void setHttpStatus(HttpStatus httpStatus) {
    this.httpStatus = httpStatus;
  }

  public String getTrace() {
    return errors.get(KEY_TRACE);
  }

  public void setTrace(String trace) {
    errors.put(KEY_TRACE, trace);
  }

  public Map<String, String> getErrors() {
    return errors;
  }

  public void setErrors() {
    put(KEY_DATA, errors);
  }

  public String getStatus() {
    return get(KEY_STATUS).toString();
  }

  public void setStatus(String status) {
    put(KEY_STATUS, status);
  }

  public String getMessage() {
    return get(KEY_MESSAGE).toString();
  }

  public void setMessage(String message) {
    put(KEY_MESSAGE, message);
  }

  public Object getData() {
    return get(KEY_DATA);
  }

  public void setData(Object data) {
    put(KEY_DATA, data);
  }


}
