package cn.bestwu.simpleframework.security.exception;

import cn.bestwu.simpleframework.web.IErrorHandler;
import cn.bestwu.simpleframework.web.RespEntity;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.util.StringUtils;

/**
 * @author Peter Wu
 */
public class SecurityOAuth2ErrorHandler implements IErrorHandler {

  @Override
  public void handlerException(Throwable error, RespEntity respEntity) {
    String message = null;
    if (error instanceof OAuth2Exception) {
      respEntity.setHttpStatus(HttpStatus.valueOf(((OAuth2Exception) error).getHttpErrorCode()));
      message = error.getMessage();
    } else if (error instanceof AccessDeniedException) {
      respEntity.setHttpStatus(HttpStatus.FORBIDDEN);
      message = error.getMessage();
    }
    if (StringUtils.hasText(message)) {
      respEntity.setMessage(message);
    }
  }
}
