package cn.bestwu.simpleframework.security;

import cn.bestwu.simpleframework.security.exception.IllegalUserException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

/**
 * 自定义UserDetailsService
 *
 * @author Peter Wu
 */
@ConditionalOnWebApplication
public class CustomUserDetailsService implements UserDetailsService {

  private final ISecurityService securityService;

  public CustomUserDetailsService(ISecurityService securityService) {
    this.securityService = securityService;
  }


  /**
   * @param username 用户名
   * @return UserDetails
   * @throws UsernameNotFoundException 未找到用户
   */
  @Override
  public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
    ISecurityUser user;
    try {
      user = securityService.findByUsername(username);
    } catch (IllegalUserException e) {
      throw e;
    } catch (Exception e) {
      throw new IllegalUserException(e.getMessage(), e);
    }
    if (user == null) {
      throw new IllegalUserException("用户名或密码错误");
    }
    return new CustomUserDetails(user, securityService.getAuthorities(user));
  }

}