package cn.bestwu.simpleframework.security.exception;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;

/**
 * 自定义异常Jackson2序列化
 *
 * @author Peter Wu
 */
public class OAuth2ExceptionJackson2Serializer extends StdSerializer<OAuth2Exception> {

	private static final long serialVersionUID = 5223328500862406031L;

	public OAuth2ExceptionJackson2Serializer() {
		super(OAuth2Exception.class);
	}

	@Override
	public void serialize(OAuth2Exception value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
		jgen.writeStartObject();
		jgen.writeStringField("status", String.valueOf(value.getHttpErrorCode()));
		jgen.writeStringField("message", AbstractOAuth2SecurityExceptionHandler.getText(value.getMessage()));
		if (value.getAdditionalInformation() != null) {
			for (Map.Entry<String, String> entry : value.getAdditionalInformation().entrySet()) {
				String key = entry.getKey();
				String add = entry.getValue();
				jgen.writeStringField(key, add);
			}
		}
		jgen.writeEndObject();
	}

}