package cn.bestwu.simpleframework.security.config;

import cn.bestwu.simpleframework.security.AccessTokenService;
import cn.bestwu.simpleframework.security.CustomUserDetailsService;
import cn.bestwu.simpleframework.security.IRevokeTokenService;
import cn.bestwu.simpleframework.security.ISecurityService;
import cn.bestwu.simpleframework.security.RevokeTokenEndpoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;

@ConditionalOnClass(OAuth2Exception.class)
@Configuration
@ConditionalOnWebApplication
public class Oauth2SecurityConfiguration {

  private final ISecurityService securityService;

  public Oauth2SecurityConfiguration(ISecurityService securityService) {
    this.securityService = securityService;
  }

  @Bean
  public RevokeTokenEndpoint revokeTokenEndpoint(
      @Qualifier("consumerTokenServices") ConsumerTokenServices consumerTokenServices,
      @Autowired(required = false) IRevokeTokenService revokeTokenService) {
    return new RevokeTokenEndpoint(consumerTokenServices, revokeTokenService);
  }

  @Bean
  public AccessTokenService accessTokenService(ClientDetails clientDetails,
      CustomUserDetailsService userDetailsService,
      AuthorizationServerTokenServices authorizationServerTokenServices) {
    return new AccessTokenService(securityService, clientDetails, userDetailsService,
        authorizationServerTokenServices);
  }

}