package cn.bestwu.simpleframework.security;

import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

/**
 * 自定义UserDetailsService
 *
 * @author Peter Wu
 */
@ConditionalOnWebApplication
public class CustomUserDetailsService implements UserDetailsService {

  private final ISecurityService securityService;

  public CustomUserDetailsService(ISecurityService securityService) {
    this.securityService = securityService;
  }


  /**
   * @param username 用户名
   * @return UserDetails
   * @throws UsernameNotFoundException 未找到用户
   */
  @Override
  public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
    ISecurityUser user = securityService.findByUsername(username);
    if (user == null) {
      throw new UsernameNotFoundException("用户名或密码错误");
    }
    return new CustomUserDetails(user, securityService.getAuthorities(user));
  }

}