package cn.bestwu.simpleframework.security;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

/**
 * @author Peter Wu
 */
public class AccessTokenService {

  private final ISecurityService securityService;
  private final ClientDetails clientDetails;
  private final UserDetailsService userDetailsService;
  private final AuthorizationServerTokenServices authorizationServerTokenServices;

  public AccessTokenService(ISecurityService securityService,
      ClientDetails clientDetails,
      UserDetailsService userDetailsService,
      AuthorizationServerTokenServices authorizationServerTokenServices) {
    this.securityService = securityService;
    this.clientDetails = clientDetails;
    this.userDetailsService = userDetailsService;
    this.authorizationServerTokenServices = authorizationServerTokenServices;
  }

  public OAuth2AccessToken getAccessToken(String username, Set<String> scope,
      Map<String, String> requestParameters) {
    OAuth2Request request = new OAuth2Request(requestParameters, clientDetails.getClientId(), null,
        true, scope,
        null, null, null, null);
    UserDetails userDetails = userDetailsService.loadUserByUsername(username);
    OAuth2Authentication auth2Authentication = new OAuth2Authentication(request,
        new UsernamePasswordAuthenticationToken(userDetails, "N/A", userDetails.getAuthorities()));
    SecurityContextHolder.getContext().setAuthentication(auth2Authentication);
    return authorizationServerTokenServices.createAccessToken(auth2Authentication);
  }

  public OAuth2AccessToken getAccessToken(ISecurityUser securityUser, Set<String> scope,
      Map<String, String> requestParameters) {
    OAuth2Request request = new OAuth2Request(requestParameters, clientDetails.getClientId(), null,
        true, scope,
        null, null, null, null);
    CustomUserDetails userDetails = new CustomUserDetails(securityUser,
        securityService.getAuthorities(securityUser));
    OAuth2Authentication auth2Authentication = new OAuth2Authentication(request,
        new UsernamePasswordAuthenticationToken(userDetails, "N/A", userDetails.getAuthorities()));
    SecurityContextHolder.getContext().setAuthentication(auth2Authentication);
    return authorizationServerTokenServices.createAccessToken(auth2Authentication);
  }

  public OAuth2AccessToken getAccessToken(String username, Set<String> scope) {
    return getAccessToken(username, scope, null);
  }

  public OAuth2AccessToken getAccessToken(String username) {
    return getAccessToken(username, Collections.singleton("trust"));
  }

}
