package cn.bestwu.simpleframework.security.exception;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.common.DefaultThrowableAnalyzer;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.error.DefaultWebResponseExceptionTranslator;
import org.springframework.security.web.util.ThrowableAnalyzer;

/**
 * @author Peter Wu
 */
public class CustomWebResponseExceptionTranslator extends DefaultWebResponseExceptionTranslator {

  private ThrowableAnalyzer throwableAnalyzer = new DefaultThrowableAnalyzer();

  @Override
  public ResponseEntity<OAuth2Exception> translate(Exception e) throws Exception {

    // Try to extract a SpringSecurityException from the stacktrace
    Throwable[] causeChain = throwableAnalyzer.determineCauseChain(e);
    Exception ase = (OAuth2Exception) throwableAnalyzer
        .getFirstThrowableOfType(OAuth2Exception.class, causeChain);

    if (ase != null) {
      return handleOAuth2Exception((OAuth2Exception) ase);
    } else {
      return handleOAuth2Exception(new OAuth2Exception(e.getMessage(), e));
    }
  }

  private ResponseEntity<OAuth2Exception> handleOAuth2Exception(OAuth2Exception e) {
    HttpHeaders headers = new HttpHeaders();
    headers.set("Cache-Control", "no-store");
    headers.set("Pragma", "no-cache");
    return new ResponseEntity<>(e, headers, HttpStatus.OK);

  }


}
