package cn.bestwu.simpleframework.security.config;

import cn.bestwu.simpleframework.security.exception.OAuth2ExceptionMixIn;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;

/**
 * @author Peter Wu
 */
@ConditionalOnClass(OAuth2Exception.class)
@ConditionalOnWebApplication
@Configuration
public class ModuleConfiguration {

  @Bean
  public Module oAuth2ExceptionModule() {
    SimpleModule module = new SimpleModule();
    module.setMixInAnnotation(OAuth2Exception.class, OAuth2ExceptionMixIn.class);
    return module;
  }

}
