/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.security.exception;

import cn.bestwu.simpleframework.security.exception.AbstractOAuth2SecurityExceptionHandler;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;

public class OAuth2ExceptionJackson2Serializer
extends StdSerializer<OAuth2Exception> {
    private static final long serialVersionUID = 5223328500862406031L;

    public OAuth2ExceptionJackson2Serializer() {
        super(OAuth2Exception.class);
    }

    public void serialize(OAuth2Exception value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("status", String.valueOf(value.getHttpErrorCode()));
        jgen.writeStringField("message", AbstractOAuth2SecurityExceptionHandler.getText(value.getMessage(), new Object[0]));
        if (value.getAdditionalInformation() != null) {
            for (Map.Entry entry : value.getAdditionalInformation().entrySet()) {
                String key = (String)entry.getKey();
                String add = (String)entry.getValue();
                jgen.writeStringField(key, add);
            }
        }
        jgen.writeEndObject();
    }
}

