/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.security.config;

import cn.bestwu.simpleframework.security.AccessTokenService;
import cn.bestwu.simpleframework.security.CustomUserDetailsService;
import cn.bestwu.simpleframework.security.ISecurityService;
import cn.bestwu.simpleframework.security.RevokeTokenEndpoint;
import cn.bestwu.simpleframework.security.URLFilterInvocationSecurityMetadataSource;
import cn.bestwu.simpleframework.security.config.CorsProperties;
import cn.bestwu.simpleframework.security.exception.OAuth2ExceptionMixIn;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={CorsProperties.class})
public class SecurityConfiguration {
    @Value(value="${security.url-filter.ignored:}")
    private String[] ignored;
    private final ISecurityService securityService;
    private final RequestMappingHandlerMapping requestMappingHandlerMapping;

    public SecurityConfiguration(ISecurityService securityService, RequestMappingHandlerMapping requestMappingHandlerMapping) {
        this.securityService = securityService;
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }

    @Bean
    public RevokeTokenEndpoint revokeTokenEndpoint(@Qualifier(value="consumerTokenServices") ConsumerTokenServices consumerTokenServices) {
        return new RevokeTokenEndpoint(consumerTokenServices);
    }

    @Bean
    public CustomUserDetailsService userDetailsService(ISecurityService securityService) {
        return new CustomUserDetailsService(securityService);
    }

    @Bean
    public AccessTokenService accessTokenService(ClientDetails clientDetails, CustomUserDetailsService userDetailsService, AuthorizationServerTokenServices authorizationServerTokenServices) {
        return new AccessTokenService(clientDetails, userDetailsService, authorizationServerTokenServices);
    }

    @Bean
    public URLFilterInvocationSecurityMetadataSource securityMetadataSource() {
        return new URLFilterInvocationSecurityMetadataSource(this.securityService, this.requestMappingHandlerMapping, this.ignored);
    }

    @Bean
    @ConditionalOnProperty(prefix="security.cors", value={"enable"}, havingValue="true")
    public CorsConfigurationSource corsConfigurationSource(CorsProperties corsProperties) {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration(corsProperties.getPath(), (CorsConfiguration)corsProperties);
        return source;
    }

    @Bean
    public Module oAuth2ExceptionModule() {
        SimpleModule module = new SimpleModule();
        module.setMixInAnnotation(OAuth2Exception.class, OAuth2ExceptionMixIn.class);
        return module;
    }
}

