/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.security;

import cn.bestwu.simpleframework.security.CustomUserDetails;
import cn.bestwu.simpleframework.security.ISecurityService;
import cn.bestwu.simpleframework.security.ISecurityUser;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@ConditionalOnWebApplication
public class CustomUserDetailsService
implements UserDetailsService {
    private final ISecurityService securityService;

    public CustomUserDetailsService(ISecurityService securityService) {
        this.securityService = securityService;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        ISecurityUser user = this.securityService.findByUsername(username);
        if (user == null) {
            throw new UsernameNotFoundException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        return new CustomUserDetails(user, this.securityService.getAuthorities(user));
    }
}

