/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.security;

import cn.bestwu.simpleframework.security.ISecurityUser;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public class CustomUserDetails
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private ISecurityUser user;
    private Collection<? extends GrantedAuthority> authorities;

    public CustomUserDetails(ISecurityUser user, Collection<? extends GrantedAuthority> authorities) {
        this.user = user;
        this.authorities = authorities;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return CustomUserDetails.sortAuthorities(this.authorities);
    }

    public String getPassword() {
        return this.user.getPassword();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    public void setUser(ISecurityUser user) {
        this.user = user;
    }

    public ISecurityUser getUser() {
        return this.user;
    }

    private static SortedSet<GrantedAuthority> sortAuthorities(Collection<? extends GrantedAuthority> authorities) {
        Assert.notNull(authorities, (String)"Cannot pass a null GrantedAuthority collection");
        TreeSet<GrantedAuthority> sortedAuthorities = new TreeSet<GrantedAuthority>(new AuthorityComparator());
        for (GrantedAuthority grantedAuthority : authorities) {
            Assert.notNull((Object)grantedAuthority, (String)"GrantedAuthority list cannot contain any null elements");
            sortedAuthorities.add(grantedAuthority);
        }
        sortedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority("authenticated"));
        return sortedAuthorities;
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof CustomUserDetails) {
            return this.getUsername().equals(((CustomUserDetails)rhs).getUsername());
        }
        return false;
    }

    public int hashCode() {
        return this.getUsername().hashCode();
    }

    private static class AuthorityComparator
    implements Comparator<GrantedAuthority>,
    Serializable {
        private static final long serialVersionUID = 500L;

        private AuthorityComparator() {
        }

        @Override
        public int compare(GrantedAuthority g1, GrantedAuthority g2) {
            if (g2.getAuthority() == null) {
                return -1;
            }
            if (g1.getAuthority() == null) {
                return 1;
            }
            return g1.getAuthority().compareTo(g2.getAuthority());
        }
    }
}

