/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.security;

import cn.bestwu.simpleframework.security.CustomUserDetailsService;
import java.util.Collections;
import java.util.Set;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

public class AccessTokenService {
    private final ClientDetails clientDetails;
    private final CustomUserDetailsService userDetailsService;
    private final AuthorizationServerTokenServices authorizationServerTokenServices;

    public AccessTokenService(ClientDetails clientDetails, CustomUserDetailsService userDetailsService, AuthorizationServerTokenServices authorizationServerTokenServices) {
        this.clientDetails = clientDetails;
        this.userDetailsService = userDetailsService;
        this.authorizationServerTokenServices = authorizationServerTokenServices;
    }

    public OAuth2AccessToken getAccessToken(String username, Set<String> scope) {
        OAuth2Request request = new OAuth2Request(null, this.clientDetails.getClientId(), null, true, scope, null, null, null, null);
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
        OAuth2Authentication auth2Authentication = new OAuth2Authentication(request, (Authentication)new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)"N/A", userDetails.getAuthorities()));
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth2Authentication);
        return this.authorizationServerTokenServices.createAccessToken(auth2Authentication);
    }

    public OAuth2AccessToken getAccessToken(String username) {
        return this.getAccessToken(username, Collections.singleton("trust"));
    }
}

