package cn.bestwu.simpleframework.security;

import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpoint;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@ConditionalOnWebApplication
@FrameworkEndpoint
public class RevokeTokenEndpoint {

  private final ConsumerTokenServices consumerTokenServices;


  public RevokeTokenEndpoint(
      @Qualifier("consumerTokenServices") ConsumerTokenServices consumerTokenServices) {
    this.consumerTokenServices = consumerTokenServices;
  }

  @RequestMapping(method = RequestMethod.DELETE, value = "/oauth/token")
  @ResponseBody
  public Object revokeToken(HttpServletRequest request, String access_token) {
    consumerTokenServices.revokeToken(access_token);
    request.getSession().removeAttribute(
        HttpSessionSecurityContextRepository.SPRING_SECURITY_CONTEXT_KEY);
    return ResponseEntity.noContent().build();
  }
}