/*
 * Decompiled with CFR 0.152.
 */
package cn.bestwu.simpleframework.security.config;

import cn.bestwu.simpleframework.security.CustomUserDetailsService;
import cn.bestwu.simpleframework.security.ISecurityService;
import cn.bestwu.simpleframework.security.RevokeTokenEndpoint;
import cn.bestwu.simpleframework.security.URLFilterInvocationSecurityMetadataSource;
import cn.bestwu.simpleframework.security.config.CorsProperties;
import cn.bestwu.simpleframework.security.exception.OAuth2ExceptionJackson2Serializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={CorsProperties.class})
public class SecurityConfiguration {
    @Value(value="${security.url-filter.ignored:}")
    private String[] ignored;
    private final ISecurityService securityService;
    private final RequestMappingHandlerMapping requestMappingHandlerMapping;

    public SecurityConfiguration(ISecurityService securityService, RequestMappingHandlerMapping requestMappingHandlerMapping) {
        this.securityService = securityService;
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }

    @Bean
    public RevokeTokenEndpoint revokeTokenEndpoint(@Qualifier(value="consumerTokenServices") ConsumerTokenServices consumerTokenServices) {
        return new RevokeTokenEndpoint(consumerTokenServices);
    }

    @Bean
    public CustomUserDetailsService userDetailsService(ISecurityService securityService) {
        return new CustomUserDetailsService(securityService);
    }

    @Bean
    public URLFilterInvocationSecurityMetadataSource securityMetadataSource() {
        return new URLFilterInvocationSecurityMetadataSource(this.securityService, this.requestMappingHandlerMapping, this.ignored);
    }

    @Bean
    @ConditionalOnProperty(prefix="security.cors", value={"enable"}, havingValue="true")
    public CorsConfigurationSource corsConfigurationSource(CorsProperties corsProperties) {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration(corsProperties.getPath(), (CorsConfiguration)corsProperties);
        return source;
    }

    @Configuration
    @ConditionalOnWebApplication
    protected static class ObjectMapperBuilderCustomizer
    implements Jackson2ObjectMapperBuilderCustomizer {
        protected ObjectMapperBuilderCustomizer() {
        }

        public void customize(Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder) {
            jacksonObjectMapperBuilder.serializerByType(OAuth2Exception.class, (JsonSerializer)new OAuth2ExceptionJackson2Serializer());
        }
    }
}

