package cn.bestwu.simpleframework.security;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author Peter Wu
 */
public interface ISecurityService {

  /**
   * @param user 用户
   * @return 用户权限
   */
  @Transactional
  default Collection<? extends GrantedAuthority> getAuthorities(ISecurityUser user) {
    return Collections.emptySet();
  }

  /**
   * @param username 用户登录名
   * @return 用户
   * @throws UsernameNotFoundException 未找到相关用户
   */
  @Transactional
  ISecurityUser findByUsername(String username) throws UsernameNotFoundException;

  /**
   * @return 所有菜单
   */
  @Transactional
  default List<? extends IMenu> findAllMenus() {
    return Collections.emptyList();
  }
}
